#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"

#include "ident.h"

#define NULL_IS_NOT_A_STRING 0
#define NR_IDENT_START 100
#define HASH_NR 100
#define HASH_VAL(s,l) ( (((int)s[l / 2]) + l) % HASH_NR )

static int current;
static int init = 0;
static ident *idents[HASH_NR], *fresh_idents = NULL;
static int *len_idents[HASH_NR];
static int nr_ident[HASH_NR], max_ident[HASH_NR];
static int nr_f_ident = 0, max_f_ident;

#define LENGTH 2000
static char *identspace;
static int rest = 0;


static void do_init()
{
    register int i;

    for (i = 0; i < HASH_NR; i++) {
	idents[i] = NULL;
	len_idents[i] = NULL;
	nr_ident[i] = max_ident[i] = 0;
    }
    init++;
}

ident make_ident(s)
    register char *s;
{
    register int i, j, k, l, es;
    register ident *id_c;
    register int *id_l;

    if (!init)
	do_init();
    if (!s)
	PSF_ASSERT(NULL_IS_NOT_A_STRING);
    l = strlen(s);
    current = HASH_VAL(s, l);

#ifdef DEBUG_IDENT
    for (i = 0; i < nr_ident[current]; i++)
	(void) fprintf(stdout, "%s ", idents[current][i]);
    (void) fprintf(stdout, "new: %s\n", s);
#endif

    if (nr_ident[current]) {
	id_l = len_idents[current];
	id_c = idents[current];
	i = 0;
	j = nr_ident[current] - 1;
	do {
	    k = (i + j) / 2;
	    if ((es = l - id_l[k]) == 0)
		es = strcmp(s, id_c[k]);
	    if (es == 0)
		return id_c[k];
	    if (i == k) {
		if (es > 0) {
		    if ((es = l - id_l[j]) == 0)
			es = strcmp(s, id_c[j]);
		    if (es == 0)
			return id_c[j];
		    k = j;
		    if (es > 0)
			k++;
		}
		break;
	    }
	    if (es > 0)
		i = k;
	    else
		j = k;
	}
	while (TRUE);
	if (nr_ident[current] == max_ident[current]) {
	    max_ident[current] *= 2;
	    idents[current] = PSF_REALLOC(idents[current], ident, max_ident[current]);
	    len_idents[current] = PSF_REALLOC(len_idents[current], int, max_ident[current]);
	    id_l = len_idents[current];
	    id_c = idents[current];
	}
	for (i = nr_ident[current]; i > k; i--) {
	    id_c[i] = id_c[i - 1];
	    id_l[i] = id_l[i - 1];
	}
    } else {
	idents[current] = PSF_NMALLOC(ident, NR_IDENT_START);
	len_idents[current] = PSF_NMALLOC(int, NR_IDENT_START);
	max_ident[current] = NR_IDENT_START;
	id_l = len_idents[current];
	id_c = idents[current];
	k = 0;
    }

    nr_ident[current]++;
    id_l[k] = l;
    l++;
    if (l >= rest) {
	identspace = PSF_NMALLOC(char, LENGTH + l);
	rest = LENGTH + l;
    }
    identspace = strcpy(identspace, s);
    id_c[k] = identspace;
    rest -= l;
    identspace += l;

#ifdef DEBUG_IDENT
    (void) fprintf(stdout, "new k: %i(%s)\n", k, idents[current][k]);
#endif

#ifdef DEBUG_IDENT
    for (i = 0; i < nr_ident; i++)
	(void) fprintf(stdout, "%s ", idents[current][i]);
    (void) fprintf(stdout, "\n");
#endif

    return (id_c[k]);
}

ident fresh_ident(s)
    char *s;

{

    if (!s)
	PSF_ASSERT(NULL_IS_NOT_A_STRING);
    if (nr_f_ident) {
	if (nr_f_ident == max_f_ident) {
	    max_f_ident *= 2;
	    fresh_idents = PSF_REALLOC(fresh_idents, ident, max_f_ident);
	}
    } else {
	fresh_idents = PSF_MALLOC(ident);
	max_f_ident = 1;
    }

    return (fresh_idents[nr_f_ident++] = psf_strdup(s));
}

void resize_idents()
{
    register int i;

    for (i = 0; i < HASH_NR; i++) {
	idents[i] = PSF_REALLOC(idents[i], ident, nr_ident[i]);
    }
    fresh_idents = PSF_REALLOC(fresh_idents, ident, nr_f_ident);
}

void show_idents()
{
    int i, j;

    for (j = 0; j < HASH_NR; j++) {
	(void) fprintf(stdout, "Identifiers:\n");
	if (nr_ident[j]) {
	    for (i = 0; i < nr_ident[j]; i++)
		(void) fprintf(stdout, "\t%s\n", idents[j][i]);
	}
    }
    if (nr_f_ident) {
	(void) fprintf(stdout, "Fresh identifiers:\n");
	for (i = 0; i < nr_f_ident; i++)
	    (void) fprintf(stdout, "\t%s\n", fresh_idents[i]);
    }
}
