'\" t
.TH TIL_PSF 1L "Nov 9, 1989" "UvA FWI" "PSF-Toolkit"
.UC 4
.SH NAME
til_psf \- translate TIL-code to a PSF specification
.SH SYNOPSIS
.B til_psf
[
.B \-ahiquv
]
[
.I filename
]
.SH DESCRIPTION
The 
.B til_psf
program translates TIL code in the named file to PSF code.
If no file is named, the standard input is used.
.PP
.B Til_psf
makes no attempt to reconstruct the module structure of the
PSF specification that the input was translated from (if that is
how it was generated).  Instead it always produces one data module
and one process module.
.SH OPTIONS
.TP
.B \-a
Adjusts operator names, for whatever purpose.
.TP
.B \-h
Prints a usage message, and exits without further processing.
.TP
.B \-i
Certain characters are remapped, in order to produce identifiers that are
legal in PSF (see table below).
.TP
.B \-q
Remove double-quotes from identifiers.
.\" Why would anyone want that?  -- hansm
.TP
.B \-u
The code generated by
.B til_psf
is sometimes not legal PSF code, due to name clashes.  The
.B \-u
option avoids this by appending a unique number to every identifier,
at some cost in readability.
.TP
.B \-v
Prints the version-number of
.IR til_psf .
.LP
The
.B \-i
option translates ASCII characters according to the following table:
.TS
center tab(	);
r1 l5 l1 l5 l1 l5 l1 l.
<space>	'spa'	(	'lpa'	;	'sco'	]	'rbr'
!	'exc'	)	'rpa'	<	'lth'	^	'hat'
"	'dqu'	*	'ast'	\&=	'eql'	\&_	'und'
#	'hsh'	+	'pls'	>	'grt'	`	'bqu'
$	'dlr'	.	'dot'	?	'que'	{	'lac'
%	'prc'	,	'cma'	@	'ats'	|	'bar'
&	'amp'	/	'fsl'	[	'lbr'	}	'rac'
'	'squ'	:	'col'	\e	'bsl'	~	'tld'
.TE
.LP
Non-identifier characters not in the table are represented in the form
.BR '255' ,
where the digits denote the decimal value of the character.
.SH SEE ALSO
.BR psf (1L)
.SH DIAGNOSTICS
Sets should be declared before used, but
.B til_psf
does not order the sets.
So sometimes the resulting code will be incorrect.
.SH AUTHORS
.TP
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
.TP
Mark van Wijk, Eindhoven Univ. of Techn. (markvw@win.tue.nl)
.TP
Hans Mulder, Eindhoven Univ. of Techn. (hansm@win.tue.nl)
