#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "env_variables.h"
#include "psf_fopen.h"
#include "psf_malloc.h"
#include "psf_standards.h"

#include "tiltype.h"
#include "adjust_names.h"
#include "main.h"
#include "prtilparts.h"
#include "prtilpsf.h"
#include "readtil.h"
#include "readtiltype.h"
#include "version.h"

extern int optind;

static int adjustnames = 0;

static char *strip_suffix(s)
    char *s;
{
    char *p, *q, *r;
    int n;

    p = strrchr(s, '/');
    p = p ? p+1 : s;
    q = strchr(p, '.');
    if (q) {
	n = q-p;
	r = PSF_NMALLOC(char, n+1);
	(void) strncpy(r,p,n);
	r[n] = '\0';
	return r;
    } else
	return p;
}

static void til_to_psf(s, fp)
    char *s;
    FILE *fp;
{
    struct module mod;

    mod.name = strip_suffix(s);
    if (read_module(&mod, fp)) {
	(void) fprintf(stderr, "Error in input\n");
	exit(1);
    }
    if (adjustnames) /* What's the use? */
	adjust_names(&mod);
    print_module(&mod, stdout);
}

static void version()
{
    (void) fprintf(stderr, "til_psf version %s, last compiled %s\n",
		   VERSION, __DATE__);
}

static void usage()
{
    (void) fprintf(stderr, "usage: %s [-ahiquv] [file]\n", progname);
}

char *progname;
char *filename;

int main(argc, argv)
    int argc;
    char *argv[];
{
    static suffix suffices[] = {{TILSUFFIX, TILSUFFIX_DEFAULT},
    				{LTSSUFFIX, LTSSUFFIX_DEFAULT},
				{NULL, NULL}};
    FILE *input;
    int opt;
    psf_file pf;

    if (argc == 0) {
	(void) fprintf(stderr, "who am I?\n");
	exit(1);
    }
    progname = psf_basename(argv[0]);

    duplicate_names_allowed = FALSE;

    while ((opt = getopt(argc, argv, "ahiquv")) != EOF) {
	switch (opt) {
	case 'a':
	    adjustnames = 1;
	    break;
	case 'h':
	    usage();
	    exit(0);
	case 'i':
	    no_illegal_chars = TRUE;
	    break;
	case 'q':
	    psf_double_quotes = TRUE;
	    break;
	case 'u':
	    duplicate_names_allowed = TRUE;
	    break;
	case 'v':
	    version();
	    break;
	default:
	    usage();
	    exit(EXIT_CMD_LINE_ERR);
	}
    }

    switch (argc - optind) {
    case 0:
	filename = "stdin";
	til_to_psf("stdin", stdin);
	break;
    case 1:
	pf = psf_fopen(argv[optind], suffices);
	input = pf.fp;
	filename = pf.name;
	til_to_psf(argv[optind], input);
	break;
    default:
	usage();
	exit(EXIT_CMD_LINE_ERR);
    }

    return EXIT_SUCCESS;
}
