#include <ctype.h>
#include <limits.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"

#include "tiltype.h"
#include "adjust_names.h"
#include "readtiltype.h"
#include "prtilparts.h"

static char *replacement[UCHAR_MAX+1];
static int unique_number = 1;

static void maps_to_itself(i)
    int i;
{
    static char itself[2*(26+26+10+1)];
	/* 26 lower case letters, 26 upper case letters, 10 digits, plus '-' */

    static char *ip = itself;

    replacement[i] = ip;
    *ip++ = i;
    *ip++ = '\0';
}

static void maps_to_decimal(i)
    int i;
{
    static char decimal[sizeof "'123'" * (UCHAR_MAX+1)];
    static char *ip = decimal;

    replacement[i] = ip;
    (void) sprintf(ip, "'%3.3u'", i);
    ip += strlen(ip)+1;
}

static void init_replacement()
{
    static struct {unsigned char ch; char *repl;} dictionary[] = {
	{' ', "'spa'"},
	{'!', "'exc'"},
	{'"', "'dqu'"},
	{'#', "'hsh'"},
	{'$', "'dlr'"},
	{'%', "'prc'"},
	{'&', "'amp'"},
	{'\'', "'squ'"},
	{'(', "'lpa'"},
	{')', "'rpa'"},
	{'*', "'ast'"},
	{'+', "'pls'"},
	{'.', "'dot'"},
	{',', "'cma'"},
	{'/', "'fsl'"},
	{':', "'col'"},
	{';', "'sco'"},
	{'<', "'lth'"},
	{'=', "'eql'"},
	{'>', "'grt'"},
	{'?', "'que'"},
	{'@', "'ats'"},
	{'[', "'lbr'"},
	{'\\', "'bsl'"},
	{']', "'rbr'"},
	{'^', "'hat'"},
	{'_', "'und'"},
	{'`', "'bqu'"},
	{'{', "'lac'"},
	{'|', "'bar'"},
	{'}', "'rac'"},
	{'~', "'tld'"},
    };

    int i;

    for (i = 0; i < sizeof dictionary/sizeof dictionary[0]; i++)
	replacement[dictionary[i].ch] = dictionary[i].repl;

    if (psf_double_quotes)
	replacement['"'] = "";
    
    for (i = 'a'; i<='z'; i++)
	maps_to_itself(i);
    for (i = 'A'; i<='Z'; i++)
	maps_to_itself(i);
    for (i = '0'; i<='9'; i++)
	maps_to_itself(i);
    maps_to_itself('-');

    for (i = 0; i<UCHAR_MAX+1; i++)
	if (!replacement[i]) {
	    if (no_illegal_chars)
		maps_to_decimal(i);
	    else
		maps_to_itself(i);
	}
}

#if 0
static void adjust_ff(ff)
    freeformat ff;
{
    freeformat f;
    char *new_name;
    char *from, *to;

    for (f = ff; f; f = f->next)
	if (strcmp(f->tag, "n") == 0) {
	    new_name = PSF_NMALLOC(char,
			5*strlen(f->info) + sizeof "-1234567890");
	    to = new_name;
	    for (from = f->info; *from; from++) {
		if (*from == '-' && (from == f->info || from[1] == '\0'))
		    (void) strcpy(to, "'hyp'");
		else
		    (void) strcpy(to, replacement[(unsigned char)*from]);
		to += strlen(to);
	    }

#define LEGAL_ID "'"			/* implausible but legal identifier */

	    if (to == new_name) {		/* old name consists of */
		(void) strcpy(to, LEGAL_ID);	/* double_quotes only */
		to += sizeof LEGAL_ID;
	    }

	    if (!duplicate_names_allowed)
		sprintf(to, "-%d", unique_number++);

	    new_name = PSF_REALLOC(new_name, char, strlen(new_name)+1);
	    PSF_FREE(f->info);
	    f->info = new_name;

	    return;
	}
}
#endif

static bool algol68_style_operator(ff, old_name)
    freeformat ff;
    char *old_name;
{
    char *new_name;
    char *from, *to;
    char buf[sizeof "1234567890"];
    int length;

#define OP_SYMS "!@$%^&+*;?~/|\\-"

    length = strlen(old_name);
    if (strspn(old_name, OP_SYMS) != length)
	return FALSE;

    if (! duplicate_names_allowed) {
	to = new_name = PSF_NMALLOC(char, length + sizeof "||1234567890");
	if (old_name[0] == '-' && old_name[1] == '-')
	    *to++ = '|';
	(void) strcpy(to, old_name);
	to += length;
	*to++ = '|';
	sprintf(buf, "%d", unique_number++);
	for (from = buf; *from; from++)
	    *to++ = OP_SYMS[*from-'0'];
	*to = '\0';

	PSF_FREE(ff->info);
	ff->info = new_name;
    } else if (*ff->info == '_') {
	to = ff->info;
	while(to[0] = to[1])
	    to++;
    }
    return TRUE;
}

static bool fortran_style_operator(ff, old_name)
    freeformat ff;
    char *old_name;
{
    char *new_name;
    int length;
    char *end, *s;
    int ch;
    
    if (old_name[0] != '.' || old_name[1] == '-')
	return FALSE;
    length = strlen(old_name);
    if (length < 3)
	return FALSE;
    end = old_name + length;
    if (end[-1] != '.' || end[-2] == '-')
	return FALSE;
    for (s = old_name+1; s < end-1; s++) {
	ch = (unsigned char)*s;
	if (isalnum(ch))
	    continue;
	if (ch == '-')
	    continue;
	return FALSE;
    }

    if (! duplicate_names_allowed) {
	new_name = PSF_NMALLOC(char, length + sizeof "-1234567890");
	(void) strcpy(new_name, old_name);
	new_name[length] = '-';
	sprintf(new_name+length+1, "%d", unique_number++);

	PSF_FREE(ff->info);
	ff->info = new_name;
    } else if (*ff->info == '_') {
	s = ff->info;
	while(s[0] = s[1])
	    s++;
    }
    return TRUE;
}

static void adjust_ff(ff, fun)
    freeformat ff;
    bool fun;
{
    freeformat f, ar;
    char *from, *to, *mark;
    char *old_name, *new_name;
    bool operator;

    operator = FALSE;

    for (f = ff; f; f = f->next)
	if (strcmp(f->tag, "n") == 0) {
	    old_name = f->info;

	    if(fun) {
		ar = PSF_MALLOC(struct new_freeformat);
		ar->tag = "arity";
		ar->next = f->next;
		f->next = ar;
		if (old_name[strlen(old_name)-1] != '_')
		    ar->info = "0";
		else {
		    operator = TRUE;
		    old_name[strlen(old_name)-1] = '\0';
		    if (*old_name != '_')
			ar->info = "1";
		    else {
			ar->info = "2";
			old_name++;
		    }
		    if (algol68_style_operator(f, old_name))
			return;
		    if (fortran_style_operator(f, old_name))
			return;
		}
	    }

	    new_name = PSF_NMALLOC(char,
				5*strlen(old_name) + sizeof ".'-1234567890.");
	    to = new_name;
	    if (operator)
		*to++ = '.';
	    mark = to;
	    if (no_illegal_chars) 
		for (from = old_name; *from; from++) {
		    if (*from == '-' && (from == old_name || from[1] == '\0'))
			(void) strcpy(to, "'hyp'");
		    else
			(void) strcpy(to, replacement[(unsigned char)*from]);
		    to += strlen(to);
		}
	    else if (psf_double_quotes) {
		for (from = old_name; *from; from++)
		    if (*from != '"')
			*to++ = *from;
	    } else {
		(void) strcpy(to, old_name);
		to += strlen(to);
	    }

	    if (to == mark)		/* old_name consists of double_quotes */
		*to++='\'';		/* force it to something non-emtpy */
	    if (!duplicate_names_allowed) {
		sprintf(to, "-%d", unique_number++);
		to += strlen(to);
	    }
	    if (operator)
		*to++ = '.';
	    *to = '\0';

	    new_name = PSF_REALLOC(new_name, char, strlen(new_name)+1);
	    PSF_FREE(f->info);
	    f->info = new_name;

	    return;
	}
}

static void adjust_sor_names(mod)
    module *mod;
{
    int i;

    for(i = 1; i <= mod->entries_table[SOR]; i++)
/*
	if (mod->sor[i].defined)
*/
	    adjust_ff(mod->sor[i].ff, FALSE);
}

static void adjust_fun_names(mod)
    module *mod;
{
    int i;

    for(i = 1; i <= mod->entries_table[FUN]; i++)
/*
	if (mod->fun[i].defined)
*/
	    adjust_ff(mod->fun[i].ff, TRUE);
}

static void adjust_atm_names(mod)
    module *mod;
{
    int i;

    for(i = 1; i <= mod->entries_table[ATM]; i++)
/*
	if (mod->atm[i].defined)
*/
	    adjust_ff(mod->atm[i].ff, TRUE);
}

static void adjust_pro_names(mod)
    module *mod;
{
    int i;

    for(i = 1; i <= mod->entries_table[PRO]; i++)
/*
	if (mod->pro[i].defined)
*/
	    adjust_ff(mod->pro[i].ff, TRUE);
}

static void adjust_set_names(mod)
    module *mod;
{
    int i;

    for(i = 1; i <= mod->entries_table[SET]; i++)
/*
	if (mod->set[i].defined)
*/
	    adjust_ff(mod->set[i].ff, TRUE);
}

static void adjust_equ_names(mod)
    module *mod;
{
    int i;

    for(i = 1; i <= mod->entries_table[EQU]; i++)
/*
	if (mod->equ[i].defined)
*/
	    adjust_ff(mod->equ[i].ff, TRUE);
}

void adjust_names(mod)
    module *mod;
{
    init_replacement();

    adjust_sor_names(mod);
    adjust_fun_names(mod);
    adjust_atm_names(mod);
    adjust_pro_names(mod);
    adjust_set_names(mod);
    adjust_equ_names(mod);
}
