#include <stdio.h>
#include "psf_prototype.h"
#include "xtiltype.h"
#include "prmtilparts.h"
#include "prmtilpsf.h"

int type_of_module(mod)
    struct module *mod;
{
    if (strcmp(mod->ff, "d") == 0)
	return (1);
    else if (strcmp(mod->ff, "p") == 0)
	return (2);
    else
	return (-1);
}

void print_data_module(mod)
    struct module *mod;
{
    print_par_section(mod->entries_table[PRM], mod->par);
    print_exp_section(mod);
    print_imp_section(mod->entries_table[IMP], mod->imp);
    print_sor_section(mod->entries_table[SOR], mod->sor);
    print_fun_section(mod->entries_table[FUN], mod->fun);
    print_var_section(mod->entries_table[VAR], mod->var);
    print_equ_section(mod->entries_table[EQU], mod->equ);
}

void print_process_module(mod)
    struct module *mod;
{
    print_par_section(mod->entries_table[PRM], mod->par);
    print_exp_section(mod);
    print_imp_section(mod->entries_table[IMP], mod->imp);
    print_atm_section(mod->entries_table[ATM], mod->atm);
    print_pro_section(mod->entries_table[PRO], mod->pro);
    print_set_section(mod->entries_table[SET], mod->set);
    print_com_section(mod->entries_table[COM], mod->com);
    print_var_section(mod->entries_table[VAR], mod->var);
    print_def_section(mod->entries_table[DEF], mod->def);
}

void print_module(mod)
    struct module *mod;
{
    int tom;

    set_print_current_module(mod);
    tom = type_of_module(mod);
    switch (tom) {
    case -1:
	fprintf(stdout, "error");
	break;
    case 1:
	fprintf(stdout, "data");
	break;
    case 2:
	fprintf(stdout, "process");
	break;
    }
    fprintf(stdout, " module %s\nbegin\n\n", mod->name);
    switch (tom) {
    case -1:
    case 1:
	print_data_module(mod);
	break;
    case 2:
	print_process_module(mod);
	break;
    }
    fprintf(stdout, "end %s\n\n", mod->name);
}
