#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"
#include "xtiltype.h"
#include "prmtilparts.h"

static struct module *current_module;
extern char *progname;

void set_print_current_module(mod)
    struct module *mod;
{
    current_module = mod;
}

void print_freeformat(table, key)
    tabletype table;
    keytype key;
{
    freeformat ff;

    switch (table) {
    case SOR:
	ff = current_module->sor[key].ff;
	break;
    case FUN:
	ff = current_module->fun[key].ff;
	break;
    case ATM:
	ff = current_module->atm[key].ff;
	break;
    case PRO:
	ff = current_module->pro[key].ff;
	break;
    case SET:
	ff = current_module->set[key].ff;
	break;
    case COM:
	ff = current_module->com[key].ff;
	break;
    case VAR:
	ff = current_module->var[key].ff;
	break;
    case EQU:
	ff = current_module->equ[key].ff;
	break;
    case DEF:
	ff = current_module->def[key].ff;
	break;
    case PRM:
	ff = current_module->par[key].ff;
	break;
    case REN:
	ff = current_module->ren[key].ff;
	break;
    case BIN:
	ff = current_module->bin[key].ff;
	break;
    case IMP:
	ff = current_module->imp[key].ff;
	break;
    case MOD:
	ff = current_module->mod[key].ff;
	break;
    case UND:
	ff = current_module->und[key].ff;
	break;
    }
    fprintf(stdout, "%s", ff);
    fflush(stdout);
}

void print_sorlist(a, ind, sep)
    arity a;
    struct indextype *ind;
    char *sep;
{
    int i, el;

    if (!a)
	return;
    el = 0;
    for (i = 0; i < a; i++) {
	if (el)
	    fprintf(stdout, "%s", sep);
	if (ind[i].table == SOR && ind[i].key == 0)
	    fprintf(stdout, "atoms");
	else
	    print_freeformat(ind[i].table, ind[i].key);
	el++;
    }
}

void printline()
{
    fprintf(stdout, "\n");
}

int infix_operator(t, k)
    tabletype t;
    keytype k;
{
    char *s;

    if (t != FUN)
	return (0);
    s = current_module->fun[k].ff;
    if (s[0] == '_' || s[strlen(s) - 1] == '_')
	return (1);
    return (0);
}

void print_ae_term(term)
    struct ae_term *term;
{
    int i, el;
    int j;
    char *s;

    if (term->t == TUPLE) {
	fprintf(stdout, "<");
	for (i = 0; i < term->a; i++) {
	    if (i)
		fprintf(stdout, ", ");
	    print_ae_term(&term->ae_list[i]);
	}
	fprintf(stdout, ">");
    } else {
	if (infix_operator(term->ind.table, term->ind.key)) {
	    s = current_module->fun[term->ind.key].ff;
	    i = 0;
	    j = 0;
	    fprintf(stdout, "(");
	    if (s[0] == '_') {
		print_ae_term(&term->ae_list[i]);
		i++;
		j++;
		putc(' ', stdout);
	    }
	    while (s[j] != '_' && s[j] != '\0') {
		putc(s[j], stdout);
		j++;
	    }
	    if (s[j] == '_') {
		putc(' ', stdout);
		print_ae_term(&term->ae_list[i]);
	    }
	    fprintf(stdout, ")");
	} else if (term->ind.table == SOR && term->ind.key == 0) {
	    fprintf(stdout, "atoms");
	} else {
	    print_freeformat(term->ind.table, term->ind.key);
	    if (!term->a)
		return;
	    fprintf(stdout, "(");
	    el = 0;
	    for (i = 0; i < term->a; i++) {
		if (el)
		    fprintf(stdout, ", ");
		print_ae_term(&term->ae_list[i]);
		el++;
	    }
	    fprintf(stdout, ")");
	}
    }
}

static int first_placeholder;
static int *var_placeholder;
static char *sep_placeholders;

void print_placeholder(key)
    keytype key;
{
    var_tuple *var_t;

    var_t = &current_module->var[key];
    fprintf(stdout, "%s in ", var_t->ff);
    print_freeformat(var_t->ind.table, var_t->ind.key);
}

void print_placeholders(term)
    struct ae_term *term;
{
    int i;

    if (term->ind.table == VAR) {
	if (current_module->
		var[term->ind.key].t == LOCAL) {
	    if (!var_placeholder[term->ind.key]) {
		if (first_placeholder) {
		    fprintf(stdout, "%s",
			    sep_placeholders);
		    first_placeholder = 0;
		} else
		    fprintf(stdout, ", ");
		print_placeholder(term->ind.key);
		var_placeholder[term->ind.key] = 1;
	    }
	}
    }
    if (term->a) {
	for (i = 0; i < term->a; i++)
	    print_placeholders(&term->ae_list[i]);
    }
}

void list_placeholders(a, term, sep)
    arity a;
    union terms *term;
    char *sep;
{
    int i;
    int ent;

    first_placeholder = 1;
    sep_placeholders = sep;
    ent = current_module->entries_table[VAR];
    var_placeholder = PSF_NMALLOC(int, ent + 1);
    for (i = 0; i < ent; i++)
	var_placeholder[i] = 0;
    if (a)
	for (i = 0; i < a; i++)
	    print_placeholders(term[i].ae_t);
    free(var_placeholder);
}

void print_s_term(term)
    struct s_term *term;
{
    int i, el;

    if (term->fun == ENU)
	fprintf(stdout, "{");
    el = 0;
    for (i = 0; i < term->a; i++) {
	if (el) {
	    switch (term->fun) {
	    case ENU:
		fprintf(stdout, ", ");
		break;
	    default:
		fprintf(stdout, " %c ", term->fun);
		break;
	    }
	}
	if (term->u_tag[i] == 0)
	    print_ae_term(term->arr[i].ae_t);
	else
	    print_s_term(term->arr[i].s_t);
	el++;
    }
    if (term->fun == ENU) {
	list_placeholders(term->a, term->arr, " | ");
	fprintf(stdout, "}");
    }
}

void print_renamings(ind)
    struct indexlist *ind;
{
    int i, el;
    ren_tuple *ri;

    if (ind->a == 0)
	return;
    fprintf(stdout, "by [\n");
    el = 0;
    for (i = 0; i < ind->a; i++) {
	ri = &(current_module->ren[ind->indlist[i].key]);
	fprintf(stdout, "\t\t\t");
	print_freeformat(ri->ind1.table, ri->ind1.key);
	fprintf(stdout, "\t -> ");
	print_freeformat(ri->ind2.table, ri->ind2.key);
	el++;
	if (el < ind->a)
	    fprintf(stdout, ",");
	printline();
    }
    fprintf(stdout, "\t\t] ");
}

void print_binlist(ind)
    struct indexlist *ind;
{
    int i;
    bin_tuple *bt;

    if (!ind->a)
	return;
    for (i = 0; i < ind->a; i++) {
	bt = &(current_module->bin[ind->indlist[i].key]);
	fprintf(stdout, "\t\t");
	print_freeformat(bt->par_ind.table, bt->par_ind.key);
	fprintf(stdout, " bound ");
	print_renamings(&bt->ren_indlist);
	fprintf(stdout, "to ");
	print_freeformat(bt->mod_ind.table, bt->mod_ind.key);
	printline();
    }
}

void print_renlist(ind)
    struct indexlist *ind;
{
    if (!ind->a)
	return;
    fprintf(stdout, "\t\trenamed ");
    print_renamings(ind);
    printline();
}

void print_sor_tuple(tuple)
    sor_tuple *tuple;
{
    fprintf(stdout, "%s", tuple->ff);
}

void print_fun_tuple(tuple)
    fun_tuple *tuple;
{
    fprintf(stdout, "%s\t: ", tuple->ff);
    print_sorlist(tuple->sor_indlist.a,
		  tuple->sor_indlist.indlist, " # ");
    fprintf(stdout, "\t-> ");
    print_sorlist(tuple->return_list.a,
		  tuple->return_list.indlist, " # ");
}

void print_atmpro_tuple(tuple)
    atm_tuple *tuple;
{
    fprintf(stdout, "%s", tuple->ff);
    if (tuple->sor_indlist.a) {
	fprintf(stdout, "\t: ");
	print_sorlist(tuple->sor_indlist.a,
		      tuple->sor_indlist.indlist, " # ");
    }
}

void print_par_section(ent, tuple)
    unsigned int ent;
    par_tuple *tuple;
{
    int i, j, el, sel, sec;
    struct indexlist *ind;
    set_tuple *set_t;

    if (!ent)
	return;
    sel = 0;
    for (i = 1; i <= ent; i++) {
	if (tuple[i].t == IMPORTS)
	    continue;
	if (!sel)
	    fprintf(stdout, "parameters\n");
	else
	    fprintf(stdout, ",\n");
	fprintf(stdout, "\t%s\n\tbegin", tuple[i].ff);
	ind = &tuple[i].par_attr;
	sec = SOR;
	el = 0;
	for (j = 0; j < ind->a; j++) {
	    if (ind->indlist[j].table != sec) {
		sec = ind->indlist[j].table;
		el = 0;
	    }
	    if (!el) {
		fprintf(stdout, "\n\t\t");
		switch (sec) {
		case SOR:
		    fprintf(stdout, "sorts");
		    break;
		case FUN:
		    fprintf(stdout, "functions");
		    break;
		case ATM:
		    fprintf(stdout, "atoms");
		    break;
		case PRO:
		    fprintf(stdout, "processes");
		    break;
		case SET:
		    fprintf(stdout, "sets");
		    break;
		}
		printline();
	    }
	    if (sec == SOR && el)
		fprintf(stdout, ",\n");
	    fprintf(stdout, "\t\t\t");
	    switch (sec) {
	    case SOR:
		print_sor_tuple(&current_module->
				sor[ind->
				    indlist[j].key]);
		break;
	    case FUN:
		print_fun_tuple(&current_module->
				fun[ind->
				    indlist[j].key]);
		break;
	    case ATM:
		print_atmpro_tuple(&current_module->
				   atm[ind->
				       indlist[j].key]);
		break;
	    case PRO:
		print_atmpro_tuple(&current_module->
				   pro[ind->
				       indlist[j].key]);
		break;
	    case SET:
		set_t = &current_module->
		    set[ind->
			indlist[j].key];
		fprintf(stdout, "\t\t\tof ");
		if (set_t->ind.key == 0)
		    fprintf(stdout,
			    "atoms\n\t\t\t\t");
		else
		    print_freeformat(
				     set_t->ind.table,
				     set_t->ind.key);
		fprintf(stdout, "%s = ", set_t->ff);
		if (set_t->u_tag)
		    print_s_term(&set_t->
				 construct.set_term);
		else
		    print_freeformat(set_t->
				     construct.sort.table,
				     set_t->
				     construct.sort.key);
		break;
	    }
	    if (sec != SOR)
		printline();
	    el++;
	}
	fprintf(stdout, "\n\tend %s", tuple[i].ff);
	sel++;
    }
    if (sel) {
	printline();
	printline();
    }
}

void print_exp_section(mod)
    struct module *mod;
{
    sor_tuple *sor_t;
    fun_tuple *fun_t;
    atm_tuple *atm_t;
    pro_tuple *pro_t;
    set_tuple *set_t;
    int i, el, sel;
    unsigned int ent;

    sel = 0;
    sor_t = mod->sor;
    if (ent = mod->entries_table[SOR]) {
	el = 0;
	for (i = 1; i <= ent; i++) {
	    if (sor_t[i].t == EXPORTS) {
		if (!sel)
		    fprintf(stdout, "exports\nbegin\n");
		if (el)
		    fprintf(stdout, ",\n\t\t");
		else
		    fprintf(stdout, "\tsorts\n\t\t");
		print_sor_tuple(&sor_t[i]);
		el++;
		sel++;
	    }
	}
	if (el) {
	    printline();
	    printline();
	}
    }
    fun_t = mod->fun;
    if (ent = mod->entries_table[FUN]) {
	el = 0;
	for (i = 1; i <= ent; i++) {
	    if (fun_t[i].t == EXPORTS) {
		if (!sel)
		    fprintf(stdout, "exports\nbegin\n");
		if (!el)
		    fprintf(stdout, "\tfunctions\n");
		fprintf(stdout, "\t\t");
		print_fun_tuple(&fun_t[i]);
		el++;
		sel++;
		printline();
	    }
	}
	if (el)
	    printline();
    }
    atm_t = mod->atm;
    if (ent = mod->entries_table[ATM]) {
	el = 0;
	for (i = 1; i <= ent; i++) {
	    if (atm_t[i].t == EXPORTS) {
		if (!sel)
		    fprintf(stdout, "exports\nbegin\n");
		if (!el)
		    fprintf(stdout, "\tatoms\n");
		fprintf(stdout, "\t\t");
		print_atmpro_tuple(&atm_t[i]);
		el++;
		sel++;
		printline();
	    }
	}
	if (el)
	    printline();
    }
    pro_t = mod->pro;
    if (ent = mod->entries_table[PRO]) {
	el = 0;
	for (i = 1; i <= ent; i++) {
	    if (pro_t[i].t == EXPORTS) {
		if (!sel)
		    fprintf(stdout, "exports\nbegin\n");
		if (!el)
		    fprintf(stdout, "\tprocesses\n");
		fprintf(stdout, "\t\t");
		print_atmpro_tuple(&pro_t[i]);
		el++;
		sel++;
		printline();
	    }
	}
	if (el)
	    printline();
    }
    set_t = mod->set;
    if (ent = mod->entries_table[SET]) {
	el = 0;
	for (i = 1; i <= ent; i++) {
	    if (set_t[i].t == EXPORTS) {
		if (!sel)
		    fprintf(stdout, "exports\nbegin\n");
		if (!el)
		    fprintf(stdout, "\tsets\n");
		fprintf(stdout, "\t\tof ");
		if (set_t[i].ind.key == 0)
		    fprintf(stdout, "atoms\n\t\t\t");
		else {
		    print_freeformat(set_t[i].ind.table,
				     set_t[i].ind.key);
		    fprintf(stdout, "\n\t\t\t");
		}
		fprintf(stdout, "%s = ", set_t[i].ff);
		if (set_t[i].u_tag)
		    print_s_term(&set_t[i].construct.
				 set_term);
		else
		    print_freeformat(set_t[i].construct.
				     sort.table, set_t[i].construct.
				     sort.key);
		printline();
		el++;
		sel++;
	    }
	}
	if (el)
	    printline();
    }
    if (sel)
	fprintf(stdout, "end\n\n");
}

void print_imp_section(ent, tuple)
    unsigned int ent;
    imp_tuple *tuple;
{
    int i, el;

    if (!ent)
	return;
    fprintf(stdout, "imports\n\t");
    el = 0;
    for (i = 1; i <= ent; i++) {
	if (el)
	    fprintf(stdout, ",\n\t");
	print_freeformat(tuple[i].mod_ind.table,
			 tuple[i].mod_ind.key);
	if (tuple[i].bin_indlist.a || tuple[i].ren_indlist.a) {
	    fprintf(stdout, " {\n");
	    if (tuple[i].t == RENBIN) {
		print_renlist(&tuple[i].ren_indlist);
		print_binlist(&tuple[i].bin_indlist);
	    } else {		/* BINREN or NBINNREN makes no difference */
		print_binlist(&tuple[i].bin_indlist);
		print_renlist(&tuple[i].ren_indlist);
	    }
	    fprintf(stdout, "\t}");
	}
	el++;
    }
    printline();
    printline();
}

void print_sor_section(ent, tuple)
    unsigned int ent;
    sor_tuple *tuple;
{
    int i, el;

    if (!ent)
	return;
    el = 0;
    for (i = 1; i <= ent; i++) {
	if (tuple[i].t == EXPORTS || tuple[i].t == IMPORTS ||
		tuple[i].t == PARAMETER)
	    continue;
	if (el)
	    fprintf(stdout, ",\n");
	else
	    fprintf(stdout, "sorts\n");
	fprintf(stdout, "\t");
	print_sor_tuple(&tuple[i]);
	el++;
    }
    if (el) {
	printline();
	printline();
    }
}

void print_fun_section(ent, tuple)
    unsigned int ent;
    fun_tuple *tuple;
{
    int i, el;

    if (!ent)
	return;
    el = 0;
    for (i = 1; i <= ent; i++) {
	if (tuple[i].t == EXPORTS || tuple[i].t == IMPORTS ||
		tuple[i].t == PARAMETER)
	    continue;
	if (!el)
	    fprintf(stdout, "functions\n");
	fprintf(stdout, "\t");
	print_fun_tuple(&tuple[i]);
	printline();
	el++;
    }
    if (el)
	printline();
}

void print_atmpro_tuples(ent, tuple, id)
    unsigned int ent;
    atm_tuple *tuple;
    char *id;
{
    int i, el;

    if (!ent)
	return;
    el = 0;
    for (i = 1; i <= ent; i++) {
	if (tuple[i].t == IMPORTS || tuple[i].t == EXPORTS ||
		tuple[i].t == PARAMETER || tuple[i].t == UNKNOWN)
	    continue;
	if (!el)
	    fprintf(stdout, "%s\n", id);
	fprintf(stdout, "\t");
	print_atmpro_tuple(&tuple[i]);
	printline();
	el++;
    }
    if (el)
	printline();
}

void print_atm_section(ent, tuple)
    unsigned int ent;
    atm_tuple *tuple;
{
    print_atmpro_tuples(ent, tuple, "atoms");
}

void print_pro_section(ent, tuple)
    unsigned int ent;
    pro_tuple *tuple;
{
    print_atmpro_tuples(ent, tuple, "processes");
}

void print_set_section(ent, tuple)
    unsigned int ent;
    set_tuple *tuple;
{
    int i, el;

    if (!ent)
	return;
    el = 0;
    for (i = 1; i <= ent; i++) {
	if (tuple[i].t == EXPORTS || tuple[i].t == IMPORTS ||
		tuple[i].t == PARAMETER)
	    continue;
	if (!el)
	    fprintf(stdout, "sets\n");
	fprintf(stdout, "\tof ");
	if (tuple[i].ind.key == 0)
	    fprintf(stdout, "atoms\n\t\t");
	else {
	    print_freeformat(tuple[i].ind.table,
			     tuple[i].ind.key);
	    fprintf(stdout, "\n\t\t");
	}
	fprintf(stdout, "%s = ", tuple[i].ff);
	if (tuple[i].u_tag)
	    print_s_term(&tuple[i].construct.set_term);
	else
	    print_freeformat(tuple[i].construct.sort.table,
			     tuple[i].construct.sort.key);
	printline();
	el++;
    }
    if (el)
	printline();
}

void print_com_section(ent, tuple)
    unsigned int ent;
    com_tuple *tuple;
{
    int i;
    union terms ut[3];

    if (!ent)
	return;
    fprintf(stdout, "communications\n");
    for (i = 1; i <= ent; i++) {
	fflush(stdout);
	fprintf(stdout, "\t");
	print_ae_term(&tuple[i].aet[0]);
	fprintf(stdout, " | ");
	print_ae_term(&tuple[i].aet[1]);
	fprintf(stdout, " = ");
	print_ae_term(&tuple[i].aet[2]);
	fflush(stdout);
	ut[0].ae_t = &tuple[i].aet[0];
	ut[1].ae_t = &tuple[i].aet[1];
	ut[2].ae_t = &tuple[i].aet[2];
	list_placeholders((arity) 3, ut, " for ");
	printline();
    }
    printline();
}

void print_var_section(ent, tuple)
    unsigned int ent;
    var_tuple *tuple;
{
    int i, el;

    if (!ent)
	return;
    el = 0;
    for (i = 1; i <= ent; i++) {
	if (tuple[i].t == IMPORTS || tuple[i].t == LOCAL)
	    continue;
	if (!el)
	    fprintf(stdout, "variables\n");
	fprintf(stdout, "\t%s\t:\t-> ", tuple[i].ff);
	print_freeformat(tuple[i].ind.table, tuple[i].ind.key);
	printline();
	el++;
    }
    if (el)
	printline();
}

void print_equation(aet1, aet2)
    struct ae_term *aet1;
    struct ae_term *aet2;
{
    print_ae_term(aet1);
    fprintf(stdout, " = ");
    print_ae_term(aet2);
}

void print_equ_section(ent, tuple)
    unsigned int ent;
    equ_tuple *tuple;
{
    int i, j;

    if (!ent)
	return;
    fprintf(stdout, "equations\n");
    for (i = 1; i <= ent; i++) {
	fprintf(stdout, "[%s]\t", tuple[i].ff);
	print_equation(&tuple[i].aet1, &tuple[i].aet2);
	if (tuple[i].a) {
	    for (j = 0; j < tuple[i].a; j++) {
		if (j)
		    fprintf(stdout, ", ");
		else
		    fprintf(stdout, " when ");
		print_equation(&tuple[i].guard[j].aet1,
			       &tuple[i].guard[j].aet2);
	    }
	}
	printline();
    }
    printline();
}

static int precedence(fun)
char fun;
{
    switch (fun) {
    case ALT:
        return(1);
    case MRG:
    case STAR:
    case SHARP:
        return(2);
    case SEQ:
        return(3);
    default:
        return(4);
    }
}

void print_process_expr(pe)
    struct process_expr *pe;
{
    struct process_expr *pexpr;
    int hook;

    switch (pe->fun) {
    case SKP:
	fprintf(stdout, "skip");
	break;
    case DLK:
	fprintf(stdout, "delta");
	break;
    case ALT:
	print_process_expr(&pe->proc_expr.pe3.pe[0]);
	fprintf(stdout, " + ");
	print_process_expr(&pe->proc_expr.pe3.pe[1]);
	break;
    case SEQ:
	if (precedence(pe->proc_expr.pe3.pe[0].fun) < precedence(pe->fun)) {
	    hook = 1;
	    fprintf(stdout, "(");
	} else
	    hook = 0;
	print_process_expr(&pe->proc_expr.pe3.pe[0]);
	if (hook)
	    fprintf(stdout, ")");
	fprintf(stdout, " . ");
	if (precedence(pe->proc_expr.pe3.pe[1].fun) <= precedence(pe->fun)) {
	    hook = 1;
	    fprintf(stdout, "(");
	} else
	    hook = 0;
	print_process_expr(&pe->proc_expr.pe3.pe[1]);
	if (hook)
	    fprintf(stdout, ")");
	break;
    case PAR:
	if (precedence(pe->proc_expr.pe3.pe[0].fun) < precedence(pe->fun)) {
	    hook = 1;
	    fprintf(stdout, "(");
	} else
	    hook = 0;
	print_process_expr(&pe->proc_expr.pe3.pe[0]);
	if (hook)
	    fprintf(stdout, ")");
	fprintf(stdout, " || ");
	if (precedence(pe->proc_expr.pe3.pe[1].fun) <= precedence(pe->fun)) {
	    hook = 1;
	    fprintf(stdout, "(");
	} else
	    hook = 0;
	print_process_expr(&pe->proc_expr.pe3.pe[1]);
	if (hook)
	    fprintf(stdout, ")");
	break;
    case INTR:
    case DISR:
	if (pe->fun == INTR)
	    fprintf(stdout, "interrupt(");
	else
	    fprintf(stdout, "disrupt(");
	print_process_expr(&pe->proc_expr.pe3.pe[0]);
	fprintf(stdout, ", ");
	print_process_expr(&pe->proc_expr.pe3.pe[1]);
	fprintf(stdout, ")");
	break;
    case PRIO:
	fprintf(stdout, "prio(");
	print_sorlist(pe->proc_expr.pe5.sets.a, pe->proc_expr.pe5.sets.indlist,
	    " > ");
	fprintf(stdout, ", ");
	print_process_expr(pe->proc_expr.pe5.pe);
	fprintf(stdout, ")");
	break;
    case STAR:
    case SHARP:
	if (precedence(pe->proc_expr.pe3.pe[0].fun) < precedence(pe->fun)) {
	    hook = 1;
	    fprintf(stdout, "(");
	} else
	    hook = 0;
	print_process_expr(&pe->proc_expr.pe3.pe[0]);
	if (hook)
	    fprintf(stdout, ")");
	if (pe->fun == STAR)
	    fprintf(stdout, " * ");
	else
	    fprintf(stdout, " # ");
	if (precedence(pe->proc_expr.pe3.pe[1].fun) <= precedence(pe->fun)) {
	    hook = 1;
	    fprintf(stdout, "(");
	} else
	    hook = 0;
	print_process_expr(&pe->proc_expr.pe3.pe[1]);
	if (hook)
	    fprintf(stdout, ")");
	break;
    case SUM:
	fprintf(stdout, "sum(");
	print_placeholder(pe->proc_expr.pe1.ind.key);
	fprintf(stdout, ", ");
	print_process_expr(pe->proc_expr.pe1.pe);
	fprintf(stdout, ")");
	break;
    case MRG:
	fprintf(stdout, "merge(");
	print_placeholder(pe->proc_expr.pe1.ind.key);
	fprintf(stdout, ", ");
	print_process_expr(pe->proc_expr.pe1.pe);
	fprintf(stdout, ")");
	break;
    case ENC:
	fprintf(stdout, "encaps(");
	if (pe->proc_expr.pe1.ind.table == SOR &&
	    pe->proc_expr.pe1.ind.key == 0)
	    fprintf(stdout, "atoms");
	else
	    print_freeformat(pe->proc_expr.pe1.ind.table,
		pe->proc_expr.pe1.ind.key);
	fprintf(stdout, ", ");
	print_process_expr(pe->proc_expr.pe1.pe);
	fprintf(stdout, ")");
	break;
    case HID:
	fprintf(stdout, "hide(");
	if (pe->proc_expr.pe1.ind.table == SOR &&
	    pe->proc_expr.pe1.ind.key == 0)
	    fprintf(stdout, "atoms");
	else
	    print_freeformat(pe->proc_expr.pe1.ind.table,
		pe->proc_expr.pe1.ind.key);
	fprintf(stdout, ", ");
	print_process_expr(pe->proc_expr.pe1.pe);
	fprintf(stdout, ")");
	break;
    case IF:
	fprintf(stdout, "[");
	print_ae_term(&pe->proc_expr.pe4.aex);
	fprintf(stdout, " = ");
	print_ae_term(&pe->proc_expr.pe4.aey);
	fprintf(stdout, "]->");
	pexpr = pe->proc_expr.pe4.pe;
	if (pexpr->fun == ALT || pexpr->fun == SEQ ||
		pexpr->fun == PAR) {
	    hook = 1;
	    fprintf(stdout, "(");
	} else
	    hook = 0;
	print_process_expr(pe->proc_expr.pe4.pe);
	if (hook)
	    fprintf(stdout, ")");
	break;
    case AET:
	print_ae_term(&pe->proc_expr.pe2);
	break;
    default:
	fprintf(stderr, "\n%s: unkown process type : '%c'\n",
		progname, pe->fun);

    }
}

void print_def_section(ent, tuple)
    unsigned int ent;
    def_tuple *tuple;
{
    int i;

    if (!ent)
	return;
    fprintf(stdout, "definitions\n");
    for (i = 1; i <= ent; i++) {
	fprintf(stdout, "\t");
	print_ae_term(&tuple[i].ae_t);
	fprintf(stdout, " = ");
	print_process_expr(&tuple[i].p_expr);
	printline();
    }
    printline();
}
