#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_fopen.h"
#include "psf_standards.h"
#include "psf_exits.h"
#include "xtiltype.h"
#include "readxtil.h"
#include "prmtilpsf.h"
#include "main.h"
#include "version.h"

char *progname;
char *filename = "stdin";	/* default */

static void version()
{
    fprintf(stderr, "mtil_psf version %s, last compiled %s\n", VERSION,
	    __DATE__);
}

static void usage()
{
    fprintf(stderr, "usage: %s [-vh] [input] \n", progname);
}


static void mtil_to_psf(fp)
    FILE *fp;
{
    int end_of_file;
    struct module *mod;

    do {
	mod = PSF_MALLOC(struct module);
	if (!(end_of_file = read_module(mod, 1, fp)))
	    print_module(mod);
    } while (!end_of_file);
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    extern int optind;
    FILE *input;
    static suffix suffixes[] = {{NULL, ".mtil"}, {NULL, NULL}};
    psf_file pf;
    int c;

    if (argc == 0) {
	(void) fprintf(stderr, "who am I ?\n");
	exit(EXIT_HELP);
    };

    progname = psf_basename(argv[0]);

    while ((c = getopt(argc, argv, "hv")) != EOF)
	switch (c) {
	case 'v':
	    version();
	    break;
	case 'h':
	    usage();
	    exit(EXIT_SUCCESS);
	    break;
	default:
	    usage();
	    exit(EXIT_CMD_LINE_ERR);
	};

    if (optind > argc)
	exit(EXIT_CMD_LINE_ERR);
    if (optind == argc)
	input = stdin;
    else {
	pf = psf_fopen(argv[optind], suffixes);
	input = pf.fp;
	filename = pf.name;
    }

    mtil_to_psf(input);
    return (EXIT_SUCCESS);
}
