#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_malloc.h"
#include "defaults.h"
#include "main.h"
#include "process.h"

#define KID ITIL_TIL

static void kid(in, out)
    char *in, *out;
{
    char *s;

    current_target = 0;
    signals_unblock();
    stdioCall(freopen(out, "w", stdout), "create", out);
    s = PSF_NMALLOC(char, strlen(psfc_bindir) + sizeof KID);
    (void) strcpy(s, psfc_bindir);
    (void) strcat(s, KID);
    (void) execl(s, KID, in, (char *) 0);
    Complain("exec", KID);
}

void til(in, out)
    char *in, *out;
{
    signals_block();
    current_target = out;
    switch (fork()) {
    case -1:
	Complain("fork", "");
    case 0:
	kid(in, out);	/* doesn't return */
    default:
	signals_unblock();
	do_wait(KID);
    }
    current_target = 0;
}
