/*
** psfDOT.c - Generate PSF Dependency Graph Representation in DOT format.
**
** H.T.G. Weffers
**
*/
#include <stdio.h>

#include "psf_prototype.h"
#include "psf_standards.h"
#include "imports.h"

static void dotheader()
{
	fprintf(stdout,"/*\n");
	fprintf(stdout,"** %s %s\n","DOT sources created by","`psf -G dot'");
	fprintf(stdout,"*/\n\n");
}

static void dottrailer()
{
	fprintf(stdout,"\n\n/*\n");
	fprintf(stdout,"** %s\n","End-Of-File");
	fprintf(stdout,"*/\n");
}

void psfdotgraph ()
{
	module m;
	import i;

	dotheader();

	fprintf(stdout,"digraph %s {\n","PSFDepGraph");
	fprintf(stdout,"%s\n","");
	fprintf(stdout,"\t%s\n","size=\"5,5\";");

	for (m=module_list; m ; m=m->next)
	{

        if (m->where)
        {
              /* Iteration */
              for (i=m->imports; i ; i=i->next)
              {
                  fprintf(stdout,"\n\t\"%s\" -> \"%s\";",
                            m->name,
                            i->uses->name
                         );
              }
        }
	}

	fprintf(stdout,"\n%s\n\n","}");

	dottrailer();
}

/*
** Last revision: July 24, 1995
**
** End-Of-Function-Implementation
*/

