#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <signal.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "defaults.h"
#include "main.h"
#include "imports.h"
#include "args.h"
#include "interface.h"

static bool option_ignore, option_clean, option_verbose;

static char buf[10240];

void parallel_compile(ignore, clean, verbose)
bool ignore, clean, verbose;
{
    module m;
    import im;
    char *in, *out;
    int comp_mtil;

    option_ignore = ignore;
    option_clean = clean;
    option_verbose = verbose;

    buf[0] = '\0';
    for (m = module_list; m; m = m->next) {
	in = psf_basename(m->tnam);
        out = PSF_NMALLOC(char, strlen(m->name) + sizeof MTILSUFFIX);
        (void) strcpy(out, m->name);
        (void) strcat(out, MTILSUFFIX);
	comp_mtil = mtil_compilandum(ignore, clean, m, in, out);
	m->tnam = out;
	out = PSF_NMALLOC(char, strlen(m->name) + sizeof ITILSUFFIX);
	(void) strcpy(out, m->name);
	(void) strcat(out, ITILSUFFIX);
	if (comp_mtil) {
	    /*
		remove .itil so also the modules that import this one will
		be recompiled
	    */
	    if (unlink(out) == -1 && errno != ENOENT)
		Complain("remove", out);
	}
	if (comp_mtil || itil_compilandum(ignore, clean, m, out)) {
	    if (buf[0] != '\0')
		strcat(buf, ", ");
	    strcat(buf, m->name);
	    strcat(buf, "(");
	    strcat(buf, comp_mtil ? "1" : "0");
	    for (im = m->imports; im; im = im->next) {
		strcat(buf, ",");
		strcat(buf, im->uses->name);
/*
		if (im->next)
		strcat(buf, ",");
*/
	    }
	    strcat(buf, ")");
	}
	m->tnam = out;
    }
/*
    fprintf(stderr, "%s\n", buf);
*/
    if (! interface_par_compile(psf_tmpdir, psf_suffix, MTILSUFFIX, ITILSUFFIX, buf)) {
	cleanup();
    }
}

