
my $verbose;
my $dir;
my $psfsuffix;
my $mtilsuffix;
my $itilsuffix;

my %processcount;
my %MAXprocesscount;
$processcount{mtil} = 0;
$MAXprocesscount{mtil} = 1;
$processcount{itil} = 0;
$MAXprocesscount{itil} = 2;

sub ProcessAlloc {
    my $type = shift;

    $processcount{$type} ++;
#    ProcessPrint();
}

sub ProcessFree {
    my $type = shift;

    $processcount{$type} --;
}

sub ProcessIsmax {
    my $type = shift;

    return ($processcount{$type} == $MAXprocesscount{$type});
}

sub ProcessIszero {
    my $type = shift;

    return ($processcount{$type} == 0);
}

sub ProcessPrint {
    print STDERR "cc: $processcount{mtil}/$MAXprocesscount{mtil} $processcount{itil}/$MAXprocesscount{itil}\n";
}

sub PrintToDo {
    my $m;

    print "mtil: ", join(", ", @mtil) , "\n";
    foreach $m (keys %triggers) {
	print STDERR "$m - $count{$m} - ";
	print STDERR join(", ", @{$triggers{$m}});
	print STDERR "\n";
    }
    foreach $m (keys %count) {
	print STDERR "$m - $count{$m}\n";
    }
}

sub ScheduleInit {
    $MAXprocesscount{mtil} = shift;
    $MAXprocesscount{itil} = shift;
    $verbose = shift;
    $dir = shift;
    $psfsuffix = shift;
    $mtilsuffix = shift;
    $itilsuffix = shift;
    my $mlist = shift;
    my $m;
    my $i;
    my $do_mtil;

    @ml = split(", ", $mlist);
    @mtil = ();
    # initialize imports and counts
    foreach $m (@ml) {
	$m =~ /^([^\(]+)\((.*)\)$/;
	$imports{$1} = [ split(",", $2) ];
	$count{$1} = 0;
	$do_mtil = shift @{$imports{$1}};
	if ($do_mtil) {
	    push @mtil, $1;
	    $count{$1} ++;
	}
    }
    # set triggers for the modules it is imported by
    foreach $m (keys %imports) {
	foreach $i (@{$imports{$m}}) {
	    push @{$triggers{$i}}, $m;
	    $count{$m} ++;
	}
    }
    # some modules don't need compilation
    foreach $m (keys %triggers) {
	if (! defined $count{$m}) {
	    foreach $ib (@{$triggers{$m}}) {
		$count{$ib} --;
	    }
	}
    }
#    PrintToDo;
}

sub ScheduleNextMtil {
    my $m;

    if (! ProcessIsmax('mtil')) {
	if ($#mtil >= 0) {
	    $m = shift @mtil;
	    if ($verbose) {
		print STDERR "compiling $m$psfsuffix\n";
	    }
	    TBsend("snd-event(mtil, \"args($dir, $m$psfsuffix, $m$mtilsuffix)\")");
	    ProcessAlloc('mtil');
	    return 1;
	}
    }
    return 0;
}

sub ScheduleNextItil {
    my $m;
    my $wait = 0;

#    if ($processcount{mtil}) {
#	return;
#    }
    if (! ProcessIsmax('itil')) {
	foreach $m (keys %count) {
	    if ($count{$m}) {
		$wait ++;
		next;
	    }
	    delete $count{$m};
	    if ($verbose) {
		print STDERR "compiling $m$mtilsuffix\n";
	    }
	    TBsend("snd-event(itil, \"args($dir, $m$mtilsuffix, $m$itilsuffix)\")");
	    ProcessAlloc('itil');
	    return;
	}
	if (ProcessIszero('itil') && ! $wait) {
	    TBsend("snd-event(result(\"ok\"))");
	    return;
	}
    }
    TBsend("snd-event(wait)");
}

sub ScheduleNext {

    if (! ScheduleNextMtil()) {
	ScheduleNextItil();
    }
}

sub ScheduleRemoveMtil {

    ProcessFree('mtil');
}

sub ScheduleRemoveItil {
    my $mod = shift;

    foreach $m (@{$triggers{$mod}}) {
	$count{$m} --;
    }
    ProcessFree('itil');
}

# called from ToolBus

sub compile {
    my $mtilprocs = shift;
    my $itilprocs = shift;
    my $args = shift;
    my $mlist;

    $args =~ /^args\(([^,]), ([^,]*), ([^,]*), ([^,]*), ([^,]*), (.*)\)$/;
    ScheduleInit($mtilprocs, $itilprocs, $1, $2, $3, $4, $5, $6);
#    ScheduleNextMtil();
#    ScheduleNextItil();
    ScheduleNext();
}

sub result {
    my $arg = shift;
    my $r;
    my $current;
    my $suffix;

    $arg =~ /^([^\(]+)\((.*)($psfsuffix|$mtilsuffix)\)$/;
    $r = $1;
    $current = $2;
    $suffix = $3;
    if ($r eq "error") {
	TBsend("snd-event(result(\"error\"))");
    } else {
	if ($suffix eq $psfsuffix) {
	    $count{$current} --;
	    ScheduleRemoveMtil();
	    ScheduleNext();
	} else {
	    ScheduleRemoveItil($current);
	    ScheduleNextItil();
	}
    }
}

sub rec_ack_event {
    my $m = shift;

    if ($m =~ /^itil$/) {
	ScheduleNextItil();
    } elsif ($m =~ /^mtil$/) {
	ScheduleNext();
    }
    # ack of wait
}

sub rec_terminate {
    exit(0);
}
