#include "psf_standards.h"

/* main.c */
extern char *progname;
extern char cwd[];
extern unsigned l_cwd;
extern char *psfc_bindir;
extern char *psf_suffix;
extern unsigned l_psf_suffix;
extern char *til_suffix;
extern char *psf_tmpdir;
extern unsigned l_psf_tmpdir;
extern char *current_target;
extern char *target_module;
extern char *outputfile;
extern char *graphformat;
extern int exit_status;
extern void cleanup PROTO_ARGS((void));
extern int main PROTO_ARGS((int argc, char **argv));

#define Complain(oper,arg) do {						\
	if(*arg) {							\
	    (void)fprintf(stderr, "%s: can't %s ", progname, oper);	\
	    perror(arg);						\
	} else {							\
	    (void)fprintf(stderr, "%s: can't ", progname);		\
	    perror(oper);						\
	}								\
	cleanup();							\
    } while (0)

#define Complain2(oper,arg) do {					\
	(void)fprintf(stderr, "%s: can't %s ", progname, oper);		\
	perror(arg);							\
	exit_status=EXIT_IO_ERR;					\
	cleanup();							\
    } while (0)

#define stdioCall(call,oper,arg) do {					\
	if(!(call))							\
	    Complain(oper,arg);						\
    } while (0)

#define sysCall(call,oper,arg) do {					\
	if((call)==-1)							\
	    Complain(oper,arg);						\
    } while (0)

#define strEqual(s,t)	(strcmp(s,t) == 0)	

#define stdioCall2(call,oper,arg) do {					\
	if(!(call))							\
	    Complain2(oper,arg);					\
    } while (0)


#define Validate(p) do							\
    if(!(p)) {								\
	(void)fprintf(stderr, "%s: out of memory\n", progname);		\
	exit_status=EXIT_MEM_ERR;					\
	cleanup();							\
    } while (0)

#define absPath(abspath,relpath) do {					\
	abspath=PSF_NMALLOC(char,l_cwd+strlen(relpath));		\
	abspath=strcpy(abspath,cwd);					\
	abspath=strcat(abspath,relpath);				\
    } while (0)

#define mkAbsPath(abspath,path)						\
	if(*path=='/')							\
	    abspath=path;						\
	else								\
	    absPath(abspath,path)
