#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <errno.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_stdarg.h"
#include "args.h"

int Option_Interface = 0;
int Option_Parallel = 0;

static FILE *interface_in;
static FILE *interface_out;

/*
 * Read a line from the input.
 */
static char line[10240];

static void interface_readline()
{
    int n;
    char *p;
    int fd;

    p = line;
    fd = fileno(interface_in);
    while (1) {
	while (read(fd, p, 1) == -1) {
	    if (errno != EAGAIN) {
		fprintf(stderr, "error\n");
		exit(1);
	    }
	}
	if (*p == '\n') {
	    *p = '\0';
	    return;
	}
	p ++;
    }
}

/*
 * Send string with format f and argument s.
 */

static void DECL_VARARGS_FUNC(interface_send, char *, fmt)
{
    va_list args;

    VARARGS_start(args, fmt);
    vfprintf(interface_out, fmt, args);
    va_end(args);
    fflush(interface_out);
}

/*
 * Receive the acknowledgement (indicating that anim is ready).
 */
static void interface_receive_ack()
{
    interface_readline();
    if (strcmp(line, "ack")) {
	fprintf(stderr, "error reading ack: %s\n", line);
    }
}

static int interface_result()
{
    interface_readline();
    if (strcmp(line, "result ok") == 0) {
	return 1;
    } else if (strcmp(line, "result error") == 0) {
	return 0;
    } else {
	fprintf(stderr, "error reading result: %s\n", line);
    }
}

/*
 * Send a quit.
 */
static void interface_quit()
{
    interface_send("quit\n");
}

int interface_mtil(dir, in, out)
    char *dir, *in, *out;
{
    interface_send("mtil(%s, %s, %s)\n", dir, in, out);
    interface_receive_ack();
    return interface_result();
}

int interface_itil(dir, in, out)
    char *dir, *in, *out;
{
    interface_send("itil(%s, %s, %s)\n", dir, in, out);
    interface_receive_ack();
    return interface_result();
}

int interface_all_itil(dir, insuffix, outsuffix, imlist)
    char *dir, *insuffix, *outsuffix, *imlist;
{
    interface_send("allitil(%d, %s, %s, %s, %s)\n", option['v'], dir, insuffix, outsuffix, imlist);
    interface_receive_ack();
    return interface_result();
}

int interface_par_compile(dir, psfsuffix, insuffix, outsuffix, imlist)
    char *dir, *psfsuffix, *insuffix, *outsuffix, *imlist;
{
    interface_send("parcompiler(%d, %s, %s, %s, %s, %s)\n", option['v'], dir, psfsuffix, insuffix, outsuffix, imlist);
    interface_receive_ack();
    return interface_result();
}

/*
 * Initialization of the Interface.
 */
void interface_init(in, out)
char *in;
char *out;
{

    /* open the pipes */
    interface_in = fdopen(open(in, O_RDONLY | O_NONBLOCK), "r");
    interface_out = fdopen(open(out, O_WRONLY), "w");

    Option_Interface = 1;
    if (option['A'])
	Option_Parallel = 1;
    atexit(interface_quit);
}
