typedef struct module {
    struct module *next;	/* must be first */
    char *name;
    struct file *where;
    char *tnam;
    enum {
	alive, dead, zombie
    } status;			/* for tsort() */
    struct import *imports;
    char *whence;		/* from what library */
    bool from_stdlib;		/* don't include this one in -X output */
} *module;

typedef struct import {
    struct import *next;
    struct module *uses;
} *import;

typedef struct file {
    struct file *next;		/* must be first */
    char *name;
    int num_modules;
    struct module *last;
    bool separandum;
} *file;

extern module module_list;
extern module *last_module;
extern file file_list;
extern char *inputfile;
extern bool unfinished_module;
extern void next_module PROTO_ARGS((char *name));
extern void check_id PROTO_ARGS((char *name));
extern void next_imports PROTO_ARGS((char *name));
extern void set_target PROTO_ARGS((char *name));
extern void list_modules PROTO_ARGS((void));
extern void dump_all PROTO_ARGS((void));
extern void call_yylex PROTO_ARGS((char *name));
