#include <assert.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>

#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_malloc.h"
#include "psf_redefs.h"
#include "psf_standards.h"
#include "defaults.h"
#include "main.h"
#include "imports.h"

#define BUFSIZE 8192
#define TMP	"/tmp/"

bool must_recompile(f1, f2, clean)
    char *f1, *f2;
    bool clean;
{
    struct stat b1, b2;

    if (clean)
	if (unlink(f2) == -1 && errno != ENOENT)
	    Complain("remove", f2);
	else
	    return TRUE;

    sysCall(stat(f1, &b1), "stat", psf_basename(f1));

    if (stat(f2, &b2) == -1) {
	if (errno == ENOENT)
	    return TRUE;
	else
	    Complain("stat", psf_basename(f2));
    }
    return b1.st_mtime > b2.st_mtime;
}

static void mark(m)
    module m;
{
    import i;

    m->status = alive;
    for (i = m->imports; i; i = i->next)
	mark(i->uses);
}

void cut(name)
    char *name;
{
    module m, *p;

    for (m = module_list; m; m = m->next) {
	if (strEqual(m->name, name)) {
	    mark(m);
	    p = &module_list;
	    while (*p) {
		if ((*p)->status == alive) {
		    p = &(*p)->next;
		} else {
		    *p = (*p)->next;
		}
	    }
	    last_module = &m->next;
	    assert(m->next == 0);

	    return;
	}
    }

    (void) fprintf(stderr, "%s: module %s not found\n", progname, name);
    exit(EXIT_SYNTAX_ERR);
}

void extract_modules(stdlib)
    bool stdlib;
{
    module m;
    int rfd, wfd;
    char *out, buf[BUFSIZE];
    bool ready;
    int n, i, w;

    if (outputfile) {
	out = outputfile;
	sysCall(wfd = open(out, O_WRONLY | O_CREAT | O_TRUNC, 0666),
		"create", outputfile);
    } else {
	out = "standard output";
	wfd = fileno(stdout);
    }

    for (m = module_list; m; m = m->next) {
	if (!stdlib && m->from_stdlib)
	    continue;
	sysCall(rfd = open(m->tnam, O_RDONLY), "read", m->tnam);
	ready = FALSE;
	while (!ready) {
	    n = read(rfd, buf, BUFSIZE);
	    switch (n) {
	    case 0:
		ready = TRUE;
		break;
	    case -1:
		Complain("read", m->tnam);	/* doesn't return */
	    default:
		for (i = 0; i < n; i += w)
		    sysCall(w = write(wfd, buf + i, n - i), "write to", out);
	    }
	}
	if (buf[i-1] != '\n') {
	    buf[0] = '\n';
	    sysCall(write(wfd,buf,1), "write to", out);
	}
		
	sysCall(close(rfd), "close", m->tnam);
    }

    if (outputfile)
	sysCall(close(wfd), "close", outputfile);
}

void rm_tmpdir(set)
    bool set;
{
    module m;
    unsigned len, ml;
    char *s, *t;

    ml = l_psf_suffix;
    len = strlen(MTILSUFFIX) + 1;
    if (len > ml)
	ml = len;
    len = strlen(ITILSUFFIX) + 1;
    if (len > ml)
	ml = len;

    for (m = module_list; m; m = m->next) {
	len = strlen(m->name);
	s = PSF_NMALLOC(char, len + ml);
	t = s + len;
	(void) strcpy(s, m->name);
	(void) strcpy(t, psf_suffix);
	sysCall(unlink(s), "unlink", s);
	(void) strcpy(t, MTILSUFFIX);
	sysCall(unlink(s), "unlink", s);
	(void) strcpy(t, ITILSUFFIX);
	sysCall(unlink(s), "unlink", s);
	free(s);
    }

    if (set) {
	s = ((module) last_module)->tnam;
	sysCall(unlink(s), "unlink", s);
    }
    len = strlen(TMP);
    for (s = psf_tmpdir; *s; s++) {
	if (strncmp(s, TMP, (int) len) == 0) {
	    psf_tmpdir[strlen(psf_tmpdir) - 1] = '\0';
	    (void) rmdir(psf_tmpdir);
	    return;
	}
    }
}
