#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_redefs.h"
#include "psf_standards.h"
#include "defaults.h"
#include "main.h"
#include "imports.h"
#include "args.h"
#include "mtil.h"

static bool option_ignore, option_clean, option_verbose;

static bool not_in_library(m, out)
    module m;
    char *out;
{
    char *inlib;
    struct stat buf;

    if (option_ignore || !m->whence)
	return TRUE;

    inlib = PSF_NMALLOC(char, strlen(m->whence) + strlen(out) + 1);
    (void) strcpy(inlib, m->whence);
    (void) strcat(inlib, out);

    if (stat(inlib, &buf) == -1) {
	if (errno != ENOENT)
	    Complain("stat", inlib);
	m->whence = 0;
	free(inlib);
	return TRUE;
    } else {
	sysCall(symlink(inlib, out), "symlink", out);
	free(inlib);
	return FALSE;
    }
}

static bool compilandum(m, in, out)
    module m;
    char *in, *out;
{
    struct stat ibuf, obuf;

    sysCall(stat(in, &ibuf), "stat", in);

    if (option_clean)
	if (unlink(out) == -1 && errno != ENOENT)
	    Complain("remove", out);
	else
	    return not_in_library(m, out);
    else if (lstat(out, &obuf) == -1)
	if (errno != ENOENT)
	    Complain("stat", out);
	else
	    return not_in_library(m, out);
    else if (S_ISLNK(obuf.st_mode))
	if (option_ignore) {
	    sysCall(unlink(out), "remove", out);
	    return TRUE;
	} else {
	    if (stat(out, &obuf)) {
		if (errno != ENOENT)
		    Complain("stat", out);
		sysCall(unlink(out), "remove", out);
		return not_in_library(m, out);
	    } else {
		return FALSE;
	    }
	}
    else if (ibuf.st_mtime < obuf.st_mtime)
	return FALSE;
    sysCall(unlink(out), "remove", out);
    return not_in_library(m, out);
}

void all_mtil(ignore, clean, verbose)
    bool ignore, clean, verbose;
{
    module m;
    char *in, *out, *liberandum;

    option_ignore = ignore;
    option_clean = clean;
    option_verbose = verbose;

    for (m = module_list; m; m = m->next) {
	liberandum = m->tnam;
	in = psf_basename(m->tnam);
	out = PSF_NMALLOC(char, strlen(m->name) + sizeof MTILSUFFIX);
	(void) strcpy(out, m->name);
	(void) strcat(out, MTILSUFFIX);
	m->tnam = out;
	if (compilandum(m, in, out)) {
	    if (option_verbose)
		(void) fprintf(stderr, "compiling %s\n", in);
	    mtil(in, out);
	}
	free(liberandum);
    }
}

int mtil_compilandum(ignore, clean, m, in, out)
bool ignore, clean;
module m;
char *in, *out;
{
    option_ignore = ignore;
    option_clean = clean;

    return compilandum(m, in, out);
}
