#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <signal.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "defaults.h"
#include "main.h"
#include "imports.h"
#include "args.h"
#include "itil.h"
#include "interface.h"

static bool option_ignore, option_clean, option_verbose;

static bool not_in_library(m, out)
    module m;
    char *out;
{
    char *inlib;
    struct stat buf;

    if (option_ignore || !m->whence)
	return TRUE;

    inlib = PSF_NMALLOC(char, strlen(m->whence) + strlen(out) + 1);
    (void) strcpy(inlib, m->whence);
    (void) strcat(inlib, out);

    if (stat(inlib, &buf) == -1) {
	if (errno != ENOENT)
	    Complain("stat", inlib);
	m->whence = 0;
	free(inlib);
	return TRUE;
    } else {
	sysCall(symlink(inlib, out), "symlink", out);
	free(inlib);
	return FALSE;
    }
}

static bool compilandum(m, out)
    module m;
    char *out;
{
    import i;
    struct stat ibuf, obuf;

    if (option_clean)
	if (unlink(out) == -1 && errno != ENOENT)
	    Complain("remove", out);
	else
	    return not_in_library(m, out);
    else if (lstat(out, &obuf) == -1)
	if (errno != ENOENT)
	    Complain("stat", out);
	else
	    return not_in_library(m, out);
    else if (S_ISLNK(obuf.st_mode)) {
	if (option_ignore) {
	    sysCall(unlink(out), "remove", out);
	    return TRUE;
	} else if (stat(out, &obuf) == -1) {
	    if (errno != ENOENT)
		Complain("stat", out);
	    sysCall(unlink(out), "remove", out);
	    return not_in_library(m, out);
	} else {
	    return FALSE;
	}
    } else {
	if (Option_Parallel) {
	    if (stat(m->tnam, &ibuf) == -1)
		return TRUE;
	} else
	    sysCall(stat(m->tnam, &ibuf), "stat", m->tnam);
	if (ibuf.st_mtime > obuf.st_mtime) {
	    sysCall(unlink(out), "remove", out);
	    return not_in_library(m, out);
	} else {
	    for (i = m->imports; i; i = i->next) {
		if (Option_Parallel) {
		    if (stat(i->uses->tnam, &ibuf) == -1)
			return TRUE;
		} else
		    sysCall(stat(i->uses->tnam, &ibuf), "stat", i->uses->tnam);
		if (ibuf.st_mtime > obuf.st_mtime) {
		    sysCall(unlink(out), "remove", out);
		    return not_in_library(m, out);
		}
	    }
	}
    }
    return FALSE;
}

static char buf[10240];

static void par_itil()
{
    module m;
    import im;
    char *out;

    buf[0] = '\0';
    for (m = module_list; m; m = m->next) {
	out = PSF_NMALLOC(char, strlen(m->name) + sizeof ITILSUFFIX);
	(void) strcpy(out, m->name);
	(void) strcat(out, ITILSUFFIX);
	if (compilandum(m, out)) {
	    if (buf[0] != '\0')
		strcat(buf, ", ");
	    strcat(buf, m->name);
	    strcat(buf, "(");
	    for (im = m->imports; im; im = im->next) {
		strcat(buf, im->uses->name);
		if (im->next)
		strcat(buf, ",");
	    }
	    strcat(buf, ")");
	}
	m->tnam = out;
    }
/*
    fprintf(stderr, "%s\n", buf);
*/
    if (! interface_all_itil(psf_tmpdir, MTILSUFFIX, ITILSUFFIX, buf)) {
	cleanup();
    }
}

void all_itil(ignore, clean, verbose)
bool ignore, clean, verbose;
{
    module m;
    char *in, *out;
    sigset_t old_mask;

    option_ignore = ignore;
    option_clean = clean;
    option_verbose = verbose;

    if (Option_Parallel)
	par_itil();
    else {
	for (m = module_list; m; m = m->next) {
	    in = m->tnam;
	    out = PSF_NMALLOC(char, strlen(m->name) + sizeof ITILSUFFIX);
	    (void) strcpy(out, m->name);
	    (void) strcat(out, ITILSUFFIX);

	    if (compilandum(m, out)) {
		if (option_verbose)
		    (void) fprintf(stderr, "compiling %s\n", in);
		itil(in, out);
	    }
	    free(in);
	    m->tnam = out;
	}
    }
}

int itil_compilandum(ignore, clean, m, out)
bool ignore, clean;
module m;
char *out;
{
    option_ignore = ignore;
    option_clean = clean;

    return compilandum(m, out);
}
