/* atmtab.c */
extern ANODE *aptr;
extern void init_atm_table PROTO_ARGS((void));
extern void add_atm_sort_ptr PROTO_ARGS((SNODE *sor_ptr));
extern void ins_atm PROTO_ARGS((char *id));
extern void ins_atm_not_last PROTO_ARGS((ID id));
extern void ins_atm_last PROTO_ARGS((ID id, AANODE *arg));
extern AANODE *add_atm_sort PROTO_ARGS((AANODE *arg, ID id));
extern ANODE *lookup_atm PROTO_ARGS((char *id));
extern BOOL atm_present PROTO_ARGS((void));
extern void show_atm PROTO_ARGS((void));
extern void clear_atm PROTO_ARGS((void));
/* comtab.c */
extern void init_com_table PROTO_ARGS((void));
extern void ins_com PROTO_ARGS((struct tnode *lhs, struct tnode *rhs, struct tnode *result));
extern BOOL com_present PROTO_ARGS((void));
extern void ins_ph PROTO_ARGS((ID id));
extern VNODE *lookup_ph PROTO_ARGS((ID id));
extern void clear_ph PROTO_ARGS((void));
extern void show_com PROTO_ARGS((void));
extern void clear_com PROTO_ARGS((void));
/* equtab.c */
extern void init_equ_table PROTO_ARGS((void));
extern void ins_equ_cond PROTO_ARGS((struct tnode *lptr, struct tnode *rptr));
extern void ins_equ PROTO_ARGS((ID id, struct tnode *lptr, struct tnode *rptr));
extern BOOL equ_present PROTO_ARGS((void));
extern void show_equ PROTO_ARGS((void));
extern void clear_cond PROTO_ARGS((ELNODE *ptr));
extern void clear_equ PROTO_ARGS((void));
/* funtab.c */
extern FNODE *fptr;
extern void init_fun_table PROTO_ARGS((void));
extern void ins_fun PROTO_ARGS((char *id));
extern void set_fun_arity PROTO_ARGS((void));
extern void add_fun_sort_ptr PROTO_ARGS((SNODE *sor_ptr));
extern void add_fun_sort PROTO_ARGS((ID id));
extern FNODE *lookup_constant PROTO_ARGS((char *id));
extern FNODE *lookup_fun PROTO_ARGS((char *id));
extern BOOL fun_present PROTO_ARGS((void));
extern void show_fun PROTO_ARGS((void));
extern int farg_cnt PROTO_ARGS((FNODE *ptr));
extern void clear_farg_list PROTO_ARGS((FANODE *ptr));
extern void clear_fun PROTO_ARGS((void));
extern void dump_fun PROTO_ARGS((void));
/* modtab.c */
extern MNODE *mptr;
extern void init_mod_table PROTO_ARGS((void));
extern MNODE *ins_mod_straight PROTO_ARGS((char *id));
extern MNODE *lookup_mod PROTO_ARGS((ID id));
extern void ins_mod PROTO_ARGS((ID id));
extern BOOL mod_present PROTO_ARGS((void));
extern void show_mod PROTO_ARGS((void));
extern void clear_mod PROTO_ARGS((void));
/* partab.c */
extern PNODE *pptr;
extern void init_par_table PROTO_ARGS((void));
extern void begin_par_sort PROTO_ARGS((void));
extern void end_par_sort PROTO_ARGS((void));
extern BOOL par_sort_flag PROTO_ARGS((void));
extern void ins_par PROTO_ARGS((char *id, TAG tag));
extern PNODE *lookup_par PROTO_ARGS((char *id));
extern void ins_par_item PROTO_ARGS((char type, int index));
extern BOOL par_present PROTO_ARGS((void));
extern void show_par PROTO_ARGS((void));
extern void clear_par PROTO_ARGS((void));
/* pdftab.c */
extern void init_pdf_table PROTO_ARGS((void));
extern void ins_pdf PROTO_ARGS((struct tnode *lptr, struct tnode *rptr));
extern BOOL pdf_present PROTO_ARGS((void));
extern void show_pdf PROTO_ARGS((void));
extern void clear_pdf PROTO_ARGS((void));
/* protab.c */
extern PRNODE *prptr;
extern void init_pro_table PROTO_ARGS((void));
extern void ins_pro PROTO_ARGS((char *id));
extern void ins_pro_not_last PROTO_ARGS((ID id));
extern void ins_pro_last PROTO_ARGS((ID id, PRANODE *arg));
extern PRANODE *add_pro_sort PROTO_ARGS((PRANODE *arg, ID id));
extern void add_pro_sort_ptr PROTO_ARGS((SNODE *sor_ptr));
extern PRNODE *lookup_pro PROTO_ARGS((char *id));
extern BOOL pro_present PROTO_ARGS((void));
extern void show_pro PROTO_ARGS((void));
extern void clear_pro PROTO_ARGS((void));
/* rbitab.c */
extern INODE *iptr;
extern BNODE *bptr;
extern RNODE *rptr;
extern void init_imp_table PROTO_ARGS((void));
extern void init_bin_table PROTO_ARGS((void));
extern void init_ren_table PROTO_ARGS((void));
extern void ins_imp PROTO_ARGS((ID id));
extern void first_modifier PROTO_ARGS((int mod));
extern void clear_imp PROTO_ARGS((void));
extern BOOL imp_present PROTO_ARGS((void));
extern void show_imp PROTO_ARGS((void));
extern void add_renaming PROTO_ARGS((ID from_id, ID to_id));
extern BOOL ren_present PROTO_ARGS((void));
extern void show_ren PROTO_ARGS((void));
extern void clear_ren PROTO_ARGS((void));
extern void add_binding PROTO_ARGS((ID from_id));
extern void binding_done PROTO_ARGS((ID to_id));
extern BOOL bin_present PROTO_ARGS((void));
extern void show_bin PROTO_ARGS((void));
extern void clear_bin PROTO_ARGS((void));
/* settab.c */
extern void init_set_table PROTO_ARGS((void));
extern BOOL set_present PROTO_ARGS((void));
extern SENODE *lookup_set PROTO_ARGS((ID id));
extern SENODE *simple_ins_set PROTO_ARGS((ID id));
extern SNODE *get_set_sort PROTO_ARGS((void));
extern void ins_set PROTO_ARGS((ID id, TNODE *ptr, SNODE *sptr));
extern void set_set_sort PROTO_ARGS((ID id));
extern void show_set PROTO_ARGS((void));
extern void clear_set PROTO_ARGS((void));
/* sortab.c */
extern SNODE *sptr;
extern void init_sor_table PROTO_ARGS((void));
extern SNODE *ins_sort_tag PROTO_ARGS((char *id, int tag));
extern SNODE *lookup_sort PROTO_ARGS((ID id));
extern void ins_sort PROTO_ARGS((ID id));
extern BOOL sor_present PROTO_ARGS((void));
extern void show_sor PROTO_ARGS((void));
extern void clear_sort PROTO_ARGS((void));
extern void dump_sor PROTO_ARGS((void));
/* trmtab.c */
extern TNODE *new_node PROTO_ARGS((ID id, TNODE *left, TNODE *right, TNODE *child, int ntype, FANODE *stype, SNODE *ptr, int arity));
extern TNODE *last_sibling PROTO_ARGS((TNODE *ptr));
extern int sibling_cnt PROTO_ARGS((TNODE *ptr));
extern void dump PROTO_ARGS((TNODE *ptr));
extern void type_leaf_node PROTO_ARGS((TNODE *ptr, int type_of_node));
extern void type_tree_node PROTO_ARGS((TNODE *ptr, int type_of_node));
extern void type_node PROTO_ARGS((TNODE *ptr, int type_of_node));
extern void print_node PROTO_ARGS((TNODE *ptr));
extern void old_print_node PROTO_ARGS((TNODE *ptr));
extern void clear_tree_sub PROTO_ARGS((TNODE *ptr));
extern void clear_tree PROTO_ARGS((TNODE *ptr));
extern void sub_type_tree PROTO_ARGS((TNODE *ptr, int mode));
extern void type_tree PROTO_ARGS((TNODE *ptr, int mode));
extern void type_comm PROTO_ARGS((TNODE *ptr));
extern void traversal PROTO_ARGS((TNODE *ptr));
extern void traverse PROTO_ARGS((TNODE *ptr));
/* undtab.c */
extern UNODE *uptr;
extern void init_und_table PROTO_ARGS((void));
extern UNODE *ins_und_straight PROTO_ARGS((char *id));
extern UNODE *lookup_und PROTO_ARGS((ID id));
extern void ins_und PROTO_ARGS((ID id));
extern BOOL und_present PROTO_ARGS((void));
extern void show_und PROTO_ARGS((void));
extern void clear_und PROTO_ARGS((void));
/* vartab.c */
extern VNODE *vptr;
extern void init_var_table PROTO_ARGS((void));
extern VNODE *lookup_var PROTO_ARGS((ID id, int tag));
extern void ins_var PROTO_ARGS((int tag, ID id));
extern void ins_var_last PROTO_ARGS((int tag, ID id, ID sort_id));
extern void var_out_of_scope PROTO_ARGS((void));
extern void phs_out_of_scope PROTO_ARGS((void));
extern BOOL var_present PROTO_ARGS((void));
extern void show_var PROTO_ARGS((void));
extern void clear_var PROTO_ARGS((void));
/* utilities.c */
extern void prerror PROTO_ARGS((char *mess));
extern TAG get_tag_flag PROTO_ARGS((void));
extern void set_tag_flag PROTO_ARGS((int tag));
extern TAG pop_tag_flag PROTO_ARGS((void));
extern void push_tag_flag PROTO_ARGS((void));
extern void check_parameter_ids PROTO_ARGS((ID id_begin, ID id_end));
extern void print_MTIL_module PROTO_ARGS((ID id_begin, ID id_end, int type));
extern void prologue PROTO_ARGS((void));
extern void epilogue PROTO_ARGS((void));
extern char *unary_op PROTO_ARGS((char *s));
extern char *binary_op PROTO_ARGS((char *s));
/* psf.l */
extern int state;
extern int yylex PROTO_ARGS((void));
extern void begin_process_term PROTO_ARGS((void));
extern void begin_set_item PROTO_ARGS((void));
extern void begin_rest PROTO_ARGS((void));
extern void restore_state PROTO_ARGS((int oldstate));
/* psf.y */
extern char *module_name;
extern int yyparse PROTO_ARGS((void));
extern void on_syntax_err PROTO_ARGS((void));
