/*
 * routines to access the variable table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"
#include "main.h"

VNODE *vptr = NULL;

static int vindex = 1;

void init_var_table()
{
    vptr = NULL;
}

VNODE *lookup_var(id, tag)
    ID id;
    int tag;
{
    VNODE *tmp;

    for (tmp = vptr; tmp != NULL; tmp = tmp->next)
	if (tmp->in_scope && strcmp(tmp->id, id) == 0 &&
		(tag == UNKNOWN || tmp->tag == tag))
	    return tmp;

    return NULL;
}

void ins_var(tag, id)
    int tag;
    ID id;
{
    VNODE *tmp;

    if (lookup_var(id, tag) != NULL) {
	(void)fprintf(stderr,
		"%s: variable \"%s\" redeclared in module \"%s\"\n",
		progname, id, module_name);
	errorseen = TRUE;
    }

    tmp = PSF_MALLOC(VNODE);
    tmp->index = vindex++;
    tmp->id = psf_strdup(id);
    tmp->tag = tag;
    tmp->in_scope = TRUE;
    tmp->mode = UND;		/* will be filled later in by ins_var_last() */
    tmp->arg.sort = NULL;
    tmp->next = vptr;
    vptr = tmp;
}

void ins_var_last(tag, id, sort_id)
    int tag;
    ID id, sort_id;
{
    VNODE *tmp;

    ins_var(tag, id);
    vptr->tag = tag;

    /* don't bother to lookup_set(), if it isn't a placeholder */
    if (vptr->tag == LOCAL && (vptr->arg.set = lookup_set(sort_id))) {
	vptr->mode = SET;
	for (tmp = vptr->next; tmp != NULL; tmp = tmp->next)
	    if (tmp->arg.set == NULL) {
		tmp->arg.set = vptr->arg.set;
		tmp->mode = SET;
	    } else
		break;
    } else {
	vptr->mode = SOR;
	if (!(vptr->arg.sort = lookup_sort(sort_id)))	/* sort not in table */
	    vptr->arg.sort = ins_sort_tag(sort_id, UNKNOWN);
	for (tmp = vptr->next; tmp != NULL; tmp = tmp->next)
	    if (tmp->arg.sort == NULL) {
		tmp->arg.sort = vptr->arg.sort;
		tmp->mode = SOR;
	    } else
		break;
    }
}

void var_out_of_scope()
{
    VNODE *tmp;

    for (tmp = vptr; tmp != NULL; tmp = tmp->next)
	if (tmp->in_scope) {
	    tmp->in_scope = FALSE;
	    return;
	}
}

void phs_out_of_scope()
{
    VNODE *tmp;

    for (tmp = vptr; tmp != NULL; tmp = tmp->next)
	if (tmp->tag == LOCAL)
	    tmp->in_scope = FALSE;
}

BOOL var_present()
{
    return vptr != NULL;
}

static void print_var(ptr)
    VNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", vindex - 1);
    } else {
	print_var(ptr->next);
	printf("[%c.%d]", VAR, ptr->index);
	if (ptr->mode == SOR)
	    printf(" %c [%c.%d] ", ptr->tag, SOR, ptr->arg.sort->index);
	else {
	    if (ptr->mode == SET)
		printf(" %c [%c.%d] ", ptr->tag, SET, ptr->arg.set->index);
	    else {
		printf("Illegal variable type\n");
	    }
	}

	printf(" \t{ %s }\n", ptr->id);
    }
}

void show_var()
{
    print_var(vptr);
}

void clear_var()
{
    VNODE *tmp, *next;

    for (tmp = vptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp->id);
	PSF_FREE(tmp);
    }

    vptr = NULL;
    vindex = 1;
}
