/*
 * ============================================================================* *
 * 
 * file: utilities.c						      * info:
 * Service routines used by the M-TIL parser      		      * *
 * 
 * ============================================================================
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"
#include "main.h"

#include "yimports.h"

static TAG tag_flag = IDLE;	/* type of tag for tuple tags */
static TAG last_tag_flag = IDLE;/* type of saved tag for tuple tags */

void prerror(mess)
    char *mess;
{
    (void) fprintf(stderr, "*** Error : %s\n", mess);
}

static void init_symbol_table()
{
    init_mod_table();
    init_par_table();
    init_und_table();
    init_ren_table();
    init_bin_table();
    init_imp_table();
    init_sor_table();
    init_fun_table();
    init_atm_table();
    init_pro_table();
    init_var_table();
    init_equ_table();
    init_com_table();
    init_set_table();
    init_pdf_table();
}

TAG get_tag_flag()
{
    return (tag_flag);
}

void set_tag_flag(tag)
    int tag;
{
    tag_flag = tag;
}

TAG pop_tag_flag()
{				/* Watch Out !!! Just a 'Stack' of height 1 */
    return (last_tag_flag);
}

void push_tag_flag()
{				/* Watch Out !!! Just a 'Stack' of height 1 */
    last_tag_flag = tag_flag;
}

static void clear_tables()
{
    clear_mod();
    clear_par();
    clear_und();
    clear_ren();
    clear_bin();
    clear_imp();
    clear_sort();
    clear_fun();
    clear_atm();
    clear_pro();
    clear_var();
    clear_equ();
    clear_com();
    clear_set();
    clear_pdf();

    /*
     * malloc_verify();
     */
}

static void table_heading(table_id)
    char table_id;
{
    printf("table %c\n", table_id);
}

static void table_ending()
{
    printf("end\n");
}

void check_parameter_ids(id_begin, id_end)
    ID id_begin, id_end;
{
    if (strcmp(id_begin, id_end) != 0) {
	fprintf(stderr,
		"%s: parameter section named \"%s\" ends with \"%s\".\n",
		progname, id_begin, id_end);
	fprintf(stderr, "%s: these names should be the same\n", progname);
	errorseen = 1;
    }
    if (strcmp(id_begin, "hidden") == 0 || strcmp(id_begin, "export") == 0) {
	fprintf(stderr,
		"%s: illegal parameter name \"%s\"\n",
		progname, id_begin);
	errorseen = 1;
    }
}

void print_MTIL_module(id_begin, id_end, type)
    ID id_begin, id_end;
    int type;
{
    if (strcmp(id_begin, id_end) != 0) {
	fprintf(stderr, "%s: module \"%s\" ends with \"%s\".\n",
		progname, id_begin, id_end);
	fprintf(stderr, "%s: these names should be the same\n", progname);
	errorseen = 1;
    }
    if (errorseen) {
	return;
    }

    printf("module %s \t\t{ %c }\n", id_begin, type);

    if (mod_present()) {
	table_heading(MOD);
	show_mod();
	table_ending();
    }
    if (par_present()) {
	table_heading(PRM);
	show_par();
	table_ending();
    }
    if (und_present()) {
	table_heading(RIT);
	show_und();
	table_ending();
    }
    if (ren_present()) {
	table_heading(REN);
	show_ren();
	table_ending();
    }
    if (bin_present()) {
	table_heading(BIN);
	show_bin();
	table_ending();
    }
    if (imp_present()) {
	table_heading(IMP);
	show_imp();
	table_ending();
    }
    if (sor_present()) {
	table_heading(SOR);
	show_sor();
	table_ending();
    }
    if (fun_present()) {
	table_heading(FUN);
	show_fun();
	table_ending();
    }
    if (atm_present()) {
	table_heading(ATM);
	show_atm();
	table_ending();
    }
    if (pro_present()) {
	table_heading(PRO);
	show_pro();
	table_ending();
    }
    if (set_present()) {
	table_heading(SET);
	show_set();
	table_ending();
    }
    if (com_present()) {
	table_heading(COM);
	show_com();
	table_ending();
    }
    if (var_present()) {
	table_heading(VAR);
	show_var();
	table_ending();
    }
    if (equ_present()) {
	table_heading(EQU);
	show_equ();
	table_ending();
    }
    if (pdf_present()) {
	table_heading(DEF);
	show_pdf();
	table_ending();
    }
    printf("end\n\n");

    clear_tables();
}

void prologue()
{
    init_symbol_table();
    begin_rest();
}

void epilogue()
{
    return;
}

char *unary_op(s)
    char *s;
{
    char *tmp;

    tmp = PSF_NMALLOC(char, strlen(s) + 2);
    (void) strcpy(tmp, s);
    (void) strcat(tmp, "_");
    return (tmp);
}

char *binary_op(s)
    char *s;
{
    char *tmp;

    tmp = PSF_NMALLOC(char, strlen(s) + 3);
    (void) strcpy(tmp, "_");
    (void) strcat(tmp, s);
    (void) strcat(tmp, "_");
    return (tmp);
}
