/*
 * routines to access the undefined table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

UNODE *uptr = NULL;

static int uindex = 1;

void init_und_table()
{
    uptr = NULL;
}

UNODE *ins_und_straight(id)
    char *id;
{
    UNODE *tmp;

    tmp = PSF_MALLOC(UNODE);
    tmp->index = uindex++;
    tmp->id = psf_strdup(id);
    tmp->next = uptr;
    uptr = tmp;

    return (tmp);
}

UNODE *lookup_und(id)
    ID id;
{
    UNODE *tmp;

    for (tmp = uptr; tmp != NULL; tmp = tmp->next)
	if (strcmp(tmp->id, id) == 0)
	    return (tmp);

    return (NULL);
}

void ins_und(id)
    ID id;
{
    /* check whether undefined is already in table */
    if (lookup_und(id) == NULL)
	(void) ins_und_straight(id);
}

BOOL und_present()
{
    return uptr != NULL;
}

static void print_und(ptr)
    UNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", uindex - 1);
    } else {
	print_und(ptr->next);
	printf("[%c.%d] \t{ %s }\n", RIT, ptr->index, ptr->id);
    }
}

void show_und()
{
    print_und(uptr);
}

void clear_und()
{
    UNODE *tmp, *next;

    for (tmp = uptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp->id);
	PSF_FREE(tmp);
    }
    uptr = NULL;
    uindex = 1;
}
