/*
 * routines to access the term structures
 */


#include <stdio.h>
#include <string.h>

#include "psf_prototype.h"
#include "psf_malloc.h"

#include "global.h"
#include "tabtypes.h"

#include "main.h"

#include "yimports.h"

TNODE *new_node(id, left, right, child, ntype, stype, ptr, arity)
    ID id;
    TNODE *left, *right, *child;
    int ntype;
    FANODE *stype;
    SNODE *ptr;
    int arity;
{
    TNODE *tmp;

    tmp = PSF_MALLOC(TNODE);
    tmp->id = psf_strdup(id);
    tmp->left = left;
    tmp->right = right;
    tmp->child = child;
    tmp->ntype = ntype;
    tmp->stype = stype;
    tmp->node.sor_ptr = ptr;
    tmp->arity = arity;

    return (tmp);
}

TNODE *last_sibling(ptr)
    TNODE *ptr;
{
    while (ptr->right != NULL)
	ptr = ptr->right;

    return (ptr);
}

static TNODE *last_child(ptr)
    TNODE *ptr;
{
    if (ptr == NULL || (ptr = ptr->child) == NULL)
	return (NULL);

    while (ptr->right != NULL)
	ptr = ptr->right;

    return (ptr);
}

int sibling_cnt(ptr)
    TNODE *ptr;
{
    int cnt = 0;

    for (; ptr != NULL; ptr = ptr->right)
	cnt++;

    return (cnt);
}

static void dump_node(ptr, level)
    TNODE *ptr;
    int level;
{
    if (ptr != NULL) {
	printf("\n----------------------<%d>----------------------------\n",
			level);
	printf("name :	%s\n", ptr->id);
	printf("address :	%lu\n", (unsigned long)ptr);
	printf("left :	%lu\n", (unsigned long)ptr->left);
	printf("right :	%lu\n", (unsigned long)ptr->right);
	printf("child :	%lu\n", (unsigned long)ptr->child);
	printf("type :	%c\n", ptr->ntype);
	printf("arity :	%d\n", ptr->arity);
	printf("symtab :	%lu\n", (unsigned long)ptr->node.sor_ptr);
	printf("type_list :	%lu\n", (unsigned long)ptr->stype);
	if (ptr->stype != NULL)
	    printf("type_la :	%lu\n", (unsigned long)ptr->stype->arg);
	printf("---------------------------------------------------\n");
    }
}

static void sub_dump(ptr, level)
    TNODE *ptr;
    int level;
{
    if (ptr != NULL) {
	dump_node(ptr, level);
	sub_dump(ptr->right, level);
	sub_dump(ptr->child, level + 1);
    }
}

void dump(ptr)
    TNODE *ptr;
{
    printf("*** Yet another dump of a node ***\n");
    sub_dump(ptr, 0);
}

/*
static void print_sibling(ptr)
    TNODE *ptr;
{
    printf("The siblings are: \n<");

    for (ptr = ptr->child; ptr != NULL; ptr = ptr->right)
	printf("<%ld> ", ptr->stype->arg);

    printf(">\n");
}

static void print_atm_arg(ptr)
    ANODE *ptr;
{
    AANODE *tmp;

    printf("The atom args. are : \n<");

    for (tmp = ptr->arg; tmp != NULL; tmp = tmp->next)
	printf("<%ld> ", tmp->arg);

    printf(">\n");
}

static void print_inp_arg(ptr)
    FNODE *ptr;
{
    FANODE *tmp;

    printf("The input args. are : \n");

    for (tmp = ptr->arg; tmp != NULL; tmp = tmp->next)
	printf("<%ld> ", tmp->arg);

    printf("\n");
}
*/

static FANODE *last_inp_arg(ptr)
    FNODE *ptr;
{
    int cnt;
    FANODE *tmp;

    for (tmp = ptr->arg, cnt = farg_cnt(ptr) - ptr->arity; cnt != 0; cnt--)
	tmp = tmp->next;

    return (tmp);
}

static BOOL ftypes_match(fun_ptr, trm_ptr)
    FNODE *fun_ptr;
    TNODE *trm_ptr;
{
    FANODE *fa_ptr;
    TNODE *t_ptr;
    int i;

    fa_ptr = last_inp_arg(fun_ptr);
    t_ptr = last_child(trm_ptr);

    for (i = 0; i != fun_ptr->arity;
		i++, fa_ptr = fa_ptr->next, t_ptr = t_ptr->left)
	if (fa_ptr->arg != t_ptr->stype->arg)
	    return (FALSE);
    return (TRUE);
}

static FNODE *find_function(ptr)
    TNODE *ptr;
{
    FNODE *tmp;

    if (ptr == NULL)		/* illegal argument */
	return (NULL);

    for (tmp = fptr; tmp != NULL; tmp = tmp->next)
	if (tmp->arity == ptr->arity)
	    if (strcmp(tmp->id, ptr->id) == 0 && ftypes_match(tmp, ptr))
		return (tmp);

    return (NULL);
}

static FNODE *insert_und_fun(ptr, type_of_node)
    TNODE *ptr;
    char type_of_node;
{
    TNODE *tmp;

    ins_fun(ptr->id);
    for (tmp = ptr->child; tmp != NULL; tmp = tmp->right)
	if (tmp->stype == NULL)
	    add_fun_sort_ptr((struct snode *) NULL);
	else
	    add_fun_sort_ptr(tmp->stype->arg);

    set_fun_arity();

    if (type_of_node == SET)
	add_fun_sort_ptr(get_set_sort());	/* type is type of set */
    else
	add_fun_sort_ptr((struct snode *) NULL); /* we don't know its type */

    return (fptr);
}

static BOOL atypes_match(atm_ptr, trm_ptr)
    ANODE *atm_ptr;
    TNODE *trm_ptr;
{
    AANODE *aa_ptr;
    TNODE *t_ptr;
    int i;

    aa_ptr = atm_ptr->arg;
    t_ptr = last_child(trm_ptr);

    for (i = 0; i != atm_ptr->arity;
		i++, aa_ptr = aa_ptr->next, t_ptr = t_ptr->left)
	if (aa_ptr->arg != t_ptr->stype->arg)
	    return (FALSE);

    return (TRUE);
}

static ANODE *find_atom(ptr)
    TNODE *ptr;
{
    ANODE *tmp;

    if (ptr == NULL)		/* illegal argument */
	return (NULL);

    for (tmp = aptr; tmp != NULL; tmp = tmp->next)
	if (tmp->arity == ptr->arity && strcmp(tmp->id, ptr->id) == 0
		&& atypes_match(tmp, ptr))
	    return (tmp);

    return (NULL);
}

static ANODE *insert_und_atm(ptr)
    TNODE *ptr;
{
    TNODE *tmp;

    ins_atm(ptr->id);

    for (tmp = ptr->child; tmp != NULL; tmp = tmp->right)
	if (tmp->stype == NULL)
	    add_atm_sort_ptr((struct snode *) NULL);
	else
	    add_atm_sort_ptr(tmp->stype->arg);

    return (aptr);
}

static BOOL ptypes_match(pro_ptr, trm_ptr)
    PRNODE *pro_ptr;
    TNODE *trm_ptr;
{
    PRANODE *pa_ptr;
    TNODE *t_ptr;
    int i;

    pa_ptr = pro_ptr->arg;
    t_ptr = last_child(trm_ptr);

    for (i = 0; i != pro_ptr->arity;
	    i++, pa_ptr = pa_ptr->next, t_ptr = t_ptr->left)
	if (pa_ptr->arg != t_ptr->stype->arg)
	    return (FALSE);

    return (TRUE);
}

static PRNODE *find_process(ptr)
    TNODE *ptr;
{
    PRNODE *tmp;

    if (ptr == NULL)		/* illegal argument */
	return (NULL);

    for (tmp = prptr; tmp != NULL; tmp = tmp->next)
	if (tmp->arity == ptr->arity && strcmp(tmp->id, ptr->id) == 0
		&& ptypes_match(tmp, ptr))
	    return (tmp);

    return (NULL);
}

static PRNODE *insert_und_pro(ptr)
    TNODE *ptr;
{
    TNODE *tmp;

    ins_pro(ptr->id);

    for (tmp = ptr->child; tmp != NULL; tmp = tmp->right)
	if (tmp->stype == NULL)
	    add_pro_sort_ptr((struct snode *) NULL);
	else
	    add_pro_sort_ptr(tmp->stype->arg);
    return (prptr);
}

static char identify_UAP_node(ptr, type_of_node)
    TNODE *ptr;
    char type_of_node;
{
    if (find_atom(ptr))
	return ATM;
    if (find_process(ptr))
	return PRO;

    push_tag_flag();
    set_tag_flag(UNKNOWN);
    insert_und_pro(ptr);
    set_tag_flag(pop_tag_flag());

    return PRO;
}

static char identify_USS_node(ptr, type_of_node)
    TNODE *ptr;
    char type_of_node;
{
    fprintf(stderr, "%s: We have a USS\n", progname);

    push_tag_flag();
    set_tag_flag(UNKNOWN);
    ins_sort(ptr->id);
    set_tag_flag(pop_tag_flag());

    return SOR;
}

static char identify_UVF_node(ptr, type_of_node)
    TNODE *ptr;
    char type_of_node;
{
    /* try a variable or placeholder first */

    switch (type_of_node) {
    case COM: case SET: if (lookup_ph(ptr->id))
			    return (VAR);
			break;
    default:		if (lookup_var(ptr->id, LOCAL))
			    return (VAR);
			break;
    }

    if (find_function(ptr) != NULL)
	return (FUN);

    insert_und_fun(ptr, type_of_node);

    return (FUN);
}

static char identify_UND_node(ptr, type_of_node)
    TNODE *ptr;
    char type_of_node;
{
    /* try a variable or placeholder first */

    switch (type_of_node) {
    case COM: case SET: if (lookup_ph(ptr->id))
			    return VAR;
			break;
    default:		if (lookup_var(ptr->id, LOCAL))
			    return VAR;
			break;
    }

    /* try an atom next */

    switch (type_of_node) {
    case COM:	return ATM;
    case SET:	return get_set_sort() ? FUN : ATM;
    case EQU:	return FUN;
    case PRO:	return PRO;
    case PDL:	return lookup_var(ptr->id, UNKNOWN) ? VAR : FUN;
    case PDR:	if (ptr->ntype == UND)
		    return (FUN);
		if (find_atom(ptr) != NULL)
		    return (ATM);
		if (find_process(ptr) != NULL)
		    return (PRO);
		return (PRO);		/* guess it is a process by default */
    default:	fprintf(stderr, "%s: Type of node : <%c>\n",
				progname, type_of_node);
		prerror("identify_node: unknown type of node");
		return (UND);
	}
}

static char identify_node(ptr, type_of_node)
    TNODE *ptr;
    char type_of_node;
{
    switch (ptr->ntype) {

    case UND:	return (identify_UND_node(ptr, type_of_node));
    case UAP:	return (identify_UAP_node(ptr, type_of_node));
    case USS:	return (identify_USS_node(ptr, type_of_node));
    case UVF:	return (identify_UVF_node(ptr, type_of_node));
    default:	fprintf(stderr, "%s: it is a <%c>\n", progname, ptr->ntype);
		prerror("identify_node: unknown type of node");
		return (ptr->ntype);
    }
    /* NOTREACHED */
}

void type_leaf_node(ptr, type_of_node)
    TNODE *ptr;
    int type_of_node;
{
    if (errorseen)
	return;

    if ((ptr->ntype == UND) || (ptr->ntype == UAP) || (ptr->ntype == UVF))
	ptr->ntype = identify_node(ptr, type_of_node);

    switch (ptr->ntype) {

    case VAR:
	if (ptr->node.var_ptr == NULL)
	    ptr->node.var_ptr = lookup_var(ptr->id, UNKNOWN);
	ptr->stype = PSF_MALLOC(struct fanode);
	ptr->stype->next = NULL;

	if (ptr->node.var_ptr->mode == SOR)
	    ptr->stype->arg = ptr->node.var_ptr->arg.sort;
	else {
	    if (ptr->node.var_ptr->mode == SET)
		ptr->stype->arg = ptr->node.var_ptr->arg.set->sort;
	    else {
		fprintf(stderr, "Cannot recover from earlier errors.\n");
		exit(1);
	    }
	}

	break;

    case ATM:
	if ((ptr->node.atm_ptr = find_atom(ptr)) == NULL)
	    ptr->node.atm_ptr = insert_und_atm(ptr);

	break;

    case FUN:
	if ((ptr->node.fun_ptr = lookup_constant(ptr->id)) == NULL) {
	    ins_fun(ptr->id);			/* it was undefined, add it */
	    if (type_of_node == SET)
		add_fun_sort_ptr(get_set_sort());    /* type is type of set */
	    else
		add_fun_sort_ptr((struct snode *) NULL);    /* we don't know
							     * its type */
	    ptr->node.fun_ptr = lookup_constant(ptr->id);
	}
	ptr->stype = PSF_MALLOC(struct fanode);
	ptr->stype->next = NULL;

	if (ptr->node.fun_ptr->arg == NULL)
	    ptr->stype->arg = NULL;
	else
	    ptr->stype->arg = ptr->node.fun_ptr->arg->arg;

	break;

    case SOR:
	if ((ptr->node.sor_ptr = lookup_sort(ptr->id)) == NULL) {
	    ptr->node.sor_ptr = ins_sort_tag(ptr->id, IMPORTS);
	}
	ptr->stype = PSF_MALLOC(struct fanode);
	ptr->stype->next = NULL;
	ptr->stype->arg = ptr->node.sor_ptr;

	break;

    case SET:
	if ((ptr->node.set_ptr = lookup_set(ptr->id)) == NULL) {
	    ptr->node.set_ptr = simple_ins_set(ptr->id);
	}
	ptr->stype = PSF_MALLOC(struct fanode);
	ptr->stype->next = NULL;
	ptr->stype->arg = ptr->node.set_ptr->sort;

	break;

    case PRO:
	if ((ptr->node.pro_ptr = find_process(ptr)) == NULL) {
	    ptr->node.pro_ptr = insert_und_pro(ptr);
	}
	break;

    case UND:
	ptr->node.und_ptr = ins_und_straight(ptr->id);
	break;

    case ENU:

    case SKP:
    case DLK:
    case GRD:

    case ATOMSET:
	break;

    default:
	fprintf(stderr, "%s: it is a <%c>\n", progname, ptr->ntype);
	prerror("type_leaf_node: unknown type of node");
	break;
    }
}

void type_tree_node(ptr, type_of_node)
    TNODE *ptr;
    int type_of_node;
{
    if (errorseen)
	return;

    if ((ptr->ntype == UND) || (ptr->ntype == UAP))
	ptr->ntype = identify_node(ptr, type_of_node);

    switch (ptr->ntype) {

    case FUN:
	if ((ptr->node.fun_ptr = find_function(ptr)) == NULL)
	    ptr->node.fun_ptr = insert_und_fun(ptr, type_of_node);

	ptr->stype = PSF_MALLOC(struct fanode);
	ptr->stype->next = NULL;

	if (ptr->node.fun_ptr->arg == NULL)
	    ptr->stype->arg = NULL;
	else
	    ptr->stype->arg = ptr->node.fun_ptr->arg->arg;

	break;

    case ATM:
	if ((ptr->node.atm_ptr = find_atom(ptr)) == NULL)
	    ptr->node.atm_ptr = insert_und_atm(ptr);

	ptr->stype = PSF_MALLOC(struct fanode);
	ptr->stype->next = NULL;

	if (ptr->node.atm_ptr->arg == NULL)
	    ptr->stype->arg = NULL;
	else
	    ptr->stype->arg = ptr->node.atm_ptr->arg->arg;

	break;

    case PRO:
	if ((ptr->node.pro_ptr = find_process(ptr)) == NULL)
	    ptr->node.pro_ptr = insert_und_pro(ptr);

	ptr->stype = PSF_MALLOC(struct fanode);
	ptr->stype->next = NULL;

	if (ptr->node.pro_ptr->arg == NULL)
	    ptr->stype->arg = NULL;
	else
	    ptr->stype->arg = ptr->node.pro_ptr->arg->arg;

	break;

    case TUP:

    case SET:

    case UNI:
    case INT:
    case DIF:
    case ENU:

    case ALT:
    case SEQ:
    case PAR:

    case INTR:
    case DISR:
    case PRIO:
    case CHAIN:

    case STAR:
    case SHARP:

    case SUM:
    case MRG:
    case ENC:
    case HID:

    case GRD:

	ptr->stype = NULL;
	break;

    default:
	fprintf(stderr, "%s: it is a <%c> @%lu\n", progname, ptr->ntype,
	    (unsigned long)ptr);
	prerror("type_tree_node: unknown type of node");
	break;
    }
}

void type_node(ptr, type_of_node)
    TNODE *ptr;
    int type_of_node;
{
    if (ptr == NULL)
	return;			/* illegal pointer */

    if (ptr->child == NULL)
	type_leaf_node(ptr, type_of_node);
    else
	type_tree_node(ptr, type_of_node);
}


void print_node(ptr)
    TNODE *ptr;
{
    if (ptr == NULL)
	return;			/* illegal node */

    switch (ptr->ntype) {

    case VAR:
	printf("[%c.%d]", VAR, ptr->node.var_ptr->index);
	break;

    case FUN:
	printf("[%c.%d]", FUN, ptr->node.fun_ptr->index);
	if (ptr->arity != 0) {
	    printf("(");
	    print_node(ptr->child);
	    printf(")");
	}
	break;

    case TUP:
	printf("<%d,", ptr->arity);
	print_node(ptr->child);
	printf(">");
	break;

    case ATM:
	printf("[%c.%d]", ATM, ptr->node.atm_ptr->index);
	if (ptr->arity != 0) {
	    printf("(");
	    print_node(ptr->child);
	    printf(")");
	}
	break;

    case UNI:
    case INT:
    case DIF:
    case ENU:
	printf("<%c,%d>(", ptr->ntype, ptr->arity);
	print_node(ptr->child);
	printf(")");
	break;

    case SET:
	printf("[%c.%d]", SET, ptr->node.set_ptr->index);
	break;

    case SOR:
	printf("[%c.%d]", SOR, ptr->node.sor_ptr->index);
	break;

    case SKP:
	printf("<%c>", SKP);
	break;
    case DLK:
	printf("<%c>", DLK);
	break;
    case PAR:
    case SEQ:
    case ALT:
    case INTR:
    case DISR:
    case STAR:
    case SHARP:
	printf("<%c,%d>(", ptr->ntype, ptr->arity);
	print_node(ptr->child);
	printf(")");
	break;

    case CHAIN:
	printf("%d ", ptr->arity);
	print_node(ptr->child);
	break;

    case ATOMSET:
	printf("[1.0]");
	break;

    case ENC:
    case HID:
    case MRG:
    case SUM:
    case PRIO:
	printf("<%c>(", ptr->ntype);
	print_node(ptr->child);
	printf(")");
	break;

    case GRD:
	printf("<f>(");
	print_node(ptr->child);
	printf(")");
	break;

    case UND:
	printf("[%c.%d]", RIT, ptr->node.und_ptr->index);
	if (ptr->arity != 0) {
	    printf("(");
	    print_node(ptr->child);
	    printf(")");
	}
	break;

    case PRO:
	printf("[%c.%d]", PRO, ptr->node.pro_ptr->index);
	if (ptr->arity != 0) {
	    printf("(");
	    print_node(ptr->child);
	    printf(")");
	}
	break;

    default:
	prerror("print_node : unknown type of node");
	break;
    }

    if (ptr->right != NULL) {
	printf(" ");
	print_node(ptr->right);
    }
}

void old_print_node(ptr)
    TNODE *ptr;
{
    if (ptr != NULL) {
	if (ptr->ntype == VAR) {
	    printf("[%c.%d]", VAR, ptr->node.var_ptr->index);
	} else {
	    if (ptr->ntype == FUN) {
		printf("[%c.%d]", FUN, ptr->node.fun_ptr->index);
		if (ptr->arity != 0) {
		    printf("(");
		    print_node(ptr->child);
		    printf(")");
		}
	    } else {
		if (ptr->ntype == TUP) {
		    printf("<%d,", ptr->arity);
		    print_node(ptr->child);
		    printf(">");
		} else {
		    if (ptr->ntype == ATM) {
			printf("[%c.%d]", ATM, ptr->node.atm_ptr->index);
			if (ptr->arity != 0) {
			    printf("(");
			    print_node(ptr->child);
			    printf(")");
			}
		    } else {
			if (ptr->ntype == UNI
				|| ptr->ntype == INT
				|| ptr->ntype == DIF
				|| ptr->ntype == ENU) {
			    printf("<_%c_.%d>(", ptr->ntype, ptr->arity);
			    print_node(ptr->child);
			    printf(")");
			}
		    }
		}
	    }
	}
	if (ptr->right != NULL) {
	    printf(",");
	    print_node(ptr->right);
	}
    }
}

static void clear_node(ptr)
    TNODE *ptr;
{
    if (ptr->stype != NULL)
	clear_farg_list(ptr->stype);

    free((char*)ptr);
}

void clear_tree_sub(ptr)
    TNODE *ptr;
{
    if (ptr != NULL) {
	clear_tree_sub(ptr->child);
	clear_tree_sub(ptr->right);
	clear_node(ptr);
    }
}

void clear_tree(ptr)
    TNODE *ptr;
{
    clear_tree_sub(ptr);
}

void sub_type_tree(ptr, mode)
    TNODE *ptr;
    int mode;
{
    if (ptr != NULL) {
	sub_type_tree(ptr->child, ptr->ntype);
	type_node(ptr, mode);
	sub_type_tree(ptr->right, mode);
    }
}

void type_tree(ptr, mode)
    TNODE *ptr;
    int mode;
{
    sub_type_tree(ptr, mode);
}

void type_comm(ptr)
    TNODE *ptr;
{
    TNODE *lhs, *rhs, *res;

    lhs = ptr->child;
    rhs = lhs->right;
    res = rhs->right;

    lhs->right = NULL;		/* remove sibling link */
    rhs->right = NULL;		/* remove sibling link */

    type_tree(lhs, COM);	/* lhs of communication */
    type_tree(rhs, COM);	/* rhs of communication */
    type_tree(res, COM);	/* result of communication */

    ins_com(lhs, rhs, res);

    clear_ph();
}

void traversal(ptr)
    TNODE *ptr;
{
    if (ptr != NULL) {
	traversal(ptr->child);
	type_node(ptr, EQU);
	traversal(ptr->right);
    }
}

void traverse(ptr)
    TNODE *ptr;
{
    traversal(ptr);
    print_node(ptr);
}
