/*
 * include file for the definitions of the different tabletypes used by
 * the PSF parser
 */

typedef struct mnode {		/* node for a module */
    int index;
    ID id;
    struct mnode *next;
} MNODE;

typedef struct panode {		/* node for a parameter argument */
    char type;
    int index;
    struct panode *next;
} PANODE;

typedef struct pnode {		/* node for a parameter */
    int index;
    TAG tag;
    ID id;
    struct panode *item;
    struct pnode *next;
} PNODE;

typedef struct unode {		/* node for a undefined renaming item */
    int index;
    ID id;
    struct unode *next;
} UNODE;

typedef struct bnode {		/* node for a binding */
    int index;
    struct pnode *parameter;
    struct mnode *bound_to;
    struct rlnode *rename;
    struct bnode *next;
} BNODE;

typedef struct blnode {		/* node for binding list */
    struct bnode *bind;
    struct blnode *next;
} BLNODE;

typedef struct rnode {		/* node for a renaming */
    int index;
    struct unode *source;
    struct unode *dest;
    struct rnode *next;
} RNODE;

typedef struct rlnode {		/* node for renaming list */
    struct rnode *rename;
    struct rlnode *next;
} RLNODE;

typedef struct inode {		/* node for an import */
    int index;
    char first_mod;		/* first modifier (binding or renaming) */
    struct mnode *module;
    struct blnode *bind;
    struct rlnode *rename;
    struct inode *next;
} INODE;

typedef struct snode {		/* node for a sort */
    int index;
    TAG tag;
    ID id;
    struct snode *redefined_as;
    struct snode *next;
} SNODE;

typedef struct fanode {		/* node for an argument of a function */
    struct snode *arg;
    struct fanode *next;
} FANODE;

typedef struct fnode {		/* node for a function */
    int index;
    TAG tag;
    ID id;
    int arity;
    struct fanode *arg;
    struct fnode *next;
} FNODE;

typedef struct aanode {		/* node for an argument of an atom */
    struct snode *arg;
    struct aanode *next;
} AANODE;

typedef struct anode {		/* node for an atom */
    int index;
    TAG tag;
    ID id;
    int arity;
    struct aanode *arg;
    struct anode *next;
} ANODE;

typedef struct pranode {	/* node for an argument of a process */
    struct snode *arg;
    struct pranode *next;
} PRANODE;

typedef struct prnode {		/* node for a process */
    int index;
    TAG tag;
    ID id;
    int arity;
    struct pranode *arg;
    struct prnode *next;
} PRNODE;

typedef struct vnode {		/* node for a variable */
    int index;
    TAG tag;
    ID id;
    int in_scope;
    char mode;
    union {
	struct snode *sort;
	struct senode *set;
    } arg;
    struct vnode *next;
} VNODE;

typedef struct tnode {		/* node for a term */
    ID id;
    struct tnode *left;
    struct tnode *right;
    struct tnode *child;
    char ntype;
    struct fanode *stype;
    union {
	struct snode *sor_ptr;
	struct fnode *fun_ptr;
	struct vnode *var_ptr;
	struct anode *atm_ptr;
	struct senode *set_ptr;
	struct prnode *pro_ptr;
	struct unode *und_ptr;
    } node;
    int arity;
} TNODE;

typedef struct elnode {		/* node for an equation condition */
    struct tnode *lhs;
    struct tnode *rhs;
    struct elnode *next;
} ELNODE;

typedef struct enode {		/* node for an equation */
    int index;
    ID id;			/* equation tag */
    struct tnode *lhs;
    struct tnode *rhs;
    struct elnode *cond;	/* list of conditions */
    struct enode *next;
} ENODE;

typedef struct phnode {		/* node for a placeholder */
    struct vnode *arg;
    struct phnode *next;
} PHNODE;

typedef struct cnode {		/* node for a communication */
    int index;
    struct tnode *lhs;
    struct tnode *rhs;
    struct tnode *result;
    struct cnode *next;
} CNODE;

typedef struct senode {		/* node for a set */
    int index;
    ID id;
    TAG tag;
    struct tnode *trm;
    struct snode *sort;
    struct senode *next;
} SENODE;

typedef struct dnode {		/* node for a process definition */
    int index;
    struct tnode *lhs;
    struct tnode *rhs;
    struct dnode *next;
} DNODE;
