/*
 * routines to access the sort table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"

SNODE *sptr = NULL;

static int sindex = 1;
static int index_cnt = 0;

void init_sor_table()
{
    sptr = NULL;
}

SNODE *ins_sort_tag(id, tag)
    char *id;
    int tag;
{
    SNODE *tmp;

    tmp = PSF_MALLOC(SNODE);
    tmp->index = sindex++;
    tmp->tag = tag;
    tmp->id = psf_strdup(id);
    tmp->next = sptr;
    sptr = tmp;

    if ((get_tag_flag() == PARAMETER) && par_sort_flag())
	ins_par_item(SOR, tmp->index);

    return (tmp);
}

SNODE *lookup_sort(id)
    ID id;
{
    SNODE *tmp;

    for (tmp = sptr; tmp != NULL; tmp = tmp->next)
	if (strcmp(tmp->id, id) == 0)
	    return (tmp);

    return (NULL);
}

void ins_sort(id)
    ID id;
{
    SNODE *tmp;

    /* check whether sort is already in table */
    if ((tmp = lookup_sort(id)) == NULL) {
	(void) ins_sort_tag(id, get_tag_flag());
	return;
    }
    /* if present and if required adjust the tag-flag */
    if (tmp->tag == IMPORTS)
	tmp->tag = get_tag_flag();
}

BOOL sor_present()
{
    return sptr != NULL;
}

static void print_sort(ptr)
    SNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", index_cnt);
	index_cnt = 0;
	return;
    } else if (ptr->tag == RDS) {		/* redefined sort ... */
	print_sort(ptr->next);
	ptr->index = ptr->redefined_as->index;	/* ... gets new index */
    } else {
	index_cnt++;
	print_sort(ptr->next);
	ptr->index = ++index_cnt;
	printf("[%c.%d] %c \t{ %s }\n", SOR, ptr->index, ptr->tag, ptr->id);
    }
}

void show_sor()
{
    index_cnt = 0;
    print_sort(sptr);
}

void clear_sort()
{
    SNODE *tmp, *next;

    for (tmp = sptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp->id);
	PSF_FREE(tmp);
    }
    sptr = NULL;
    sindex = 1;
}

void dump_sor()
{
    SNODE *tmp;

    printf("*** sort table ***\n\n");

    for (tmp = sptr; tmp != NULL; tmp = tmp->next) {
	printf("\nname:\t<%s>\n", tmp->id);
	printf("loc:\t<%ld>\n", tmp);
	printf("ind:\t<%d>\n", tmp->index);
	printf("tag:\t<%c>\n", tmp->tag);
	printf("next:\t<%ld>\n", tmp->next);
    }

    printf("*** end of sort table ***\n\n");
}
