/*
 * routines to access the renaming, binding and imports tables used by
 * the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"

INODE *iptr = NULL;
BNODE *bptr = NULL;
RNODE *rptr = NULL;

static BOOL inside_binding = FALSE;	/* renamings belong to binding ? */
static int iindex = 1;
static int bindex = 1;
static int rnindex = 1;

void init_imp_table()
{
    iptr = NULL;
}

void init_bin_table()
{
    bptr = NULL;
}

void init_ren_table()
{
    rptr = NULL;
}

void ins_imp(id)
    ID id;
{
    INODE *tmp;

    tmp = PSF_MALLOC(INODE);
    tmp->index = iindex++;
    tmp->module = lookup_mod(id);
    tmp->first_mod = UND;	/* initially the order is undefined */
    tmp->bind = NULL;
    tmp->rename = NULL;
    tmp->next = iptr;
    iptr = tmp;
}

void first_modifier(mod)
    int mod;
{
    iptr->first_mod = mod;
}


static INODE *lookup_import(id)	/* USED ??????? */
    ID id;
{
    INODE *tmp;

    for (tmp = iptr; tmp != NULL; tmp = tmp->next)
	if (strcmp(tmp->module->id, id) == 0)
	    return (tmp);
    return (NULL);
}

static void clear_blist(ptr)
    BLNODE *ptr;
{
    BLNODE *tmp, *next;

    for (tmp = ptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp);
    }
}

static void clear_rlist(ptr)
    RLNODE *ptr;
{
    RLNODE *tmp, *next;

    for (tmp = ptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp);
    }
}

void clear_imp()
{
    INODE *tmp, *next;

    for (tmp = iptr; tmp != NULL; tmp = next) {
	clear_blist(tmp->bind);
	clear_rlist(tmp->rename);
	next = tmp->next;
	PSF_FREE(tmp);
    }
    iptr = NULL;
    iindex = 1;
}

BOOL imp_present()
{
    return iptr != NULL;
}

static void print_rlist(ptr, cnt)
    RLNODE *ptr;
    int cnt;
{
    if (ptr == NULL) {
	printf("%d ", cnt);
	return;
    } else {
	print_rlist(ptr->next, cnt + 1);
	printf("[%c.%d] ", REN, ptr->rename->index);
    }
}

static void print_blist(ptr, cnt)
    BLNODE *ptr;
    int cnt;
{
    if (ptr == NULL) {
	printf("%d ", cnt);
	return;
    } else {
	print_blist(ptr->next, cnt + 1);
	printf("[%c.%d] ", BIN, ptr->bind->index);
    }
}

static void print_imp(ptr)
    INODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", iindex - 1);
	return;
    } else {
	print_imp(ptr->next);
	printf("[%c.%d] [%c.%d] %c ",
	       IMP, ptr->index, MOD, ptr->module->index, ptr->first_mod);
	print_blist(ptr->bind, 0);
	print_rlist(ptr->rename, 0);
	printf("\t{ }\n");
    }
}

void show_imp()
{
    print_imp(iptr);
}

void add_renaming(from_id, to_id)
    ID from_id, to_id;
{
    RNODE *tmp;
    RLNODE *ltmp;

    tmp = PSF_MALLOC(RNODE);

    tmp->index = rnindex++;
    ins_und(from_id);
    tmp->source = lookup_und(from_id);
    ins_und(to_id);
    tmp->dest = lookup_und(to_id);

    tmp->next = rptr;
    rptr = tmp;

    ltmp = PSF_MALLOC(RLNODE);
    ltmp->rename = tmp;

    if (inside_binding) {
	ltmp->next = bptr->rename;
	bptr->rename = ltmp;
    } else {
	ltmp->next = iptr->rename;
	iptr->rename = ltmp;
    }
}

BOOL ren_present()
{
    return rptr != NULL;
}

static void print_renaming(ptr)
    RNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", rnindex - 1);
	return;
    } else {
	print_renaming(ptr->next);
	printf("[%c.%d] ", REN, ptr->index);
	printf("[%c.%d] ", RIT, ptr->source->index);
	printf("[%c.%d] ", RIT, ptr->dest->index);
	printf("\t { }\n");
    }
}

void show_ren()
{
    print_renaming(rptr);
}

void clear_ren()
{
    RNODE *tmp, *next;

    for (tmp = rptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	/* They refer to parts of other structures.
	    Do not free them here, 'cos they are freed somewhere else.
	PSF_FREE(tmp->source);
	PSF_FREE(tmp->dest);
	*/
	PSF_FREE(tmp);
    }
    rptr = NULL;
    rnindex = 1;
}

void add_binding(from_id)
    ID from_id;
{
    BNODE *tmp;
    BLNODE *ltmp;

    inside_binding = TRUE;

    tmp = PSF_MALLOC(BNODE);
    tmp->index = bindex++;
    tmp->rename = NULL;
    tmp->bound_to = NULL;
    tmp->parameter = lookup_par(from_id);
    tmp->next = bptr;
    bptr = tmp;

    ltmp = PSF_MALLOC(BLNODE);
    ltmp->bind = tmp;
    ltmp->next = iptr->bind;
    iptr->bind = ltmp;
}

void binding_done(to_id)
    ID to_id;
{
    inside_binding = FALSE;

    bptr->bound_to = lookup_mod(to_id);
}

BOOL bin_present()
{
    return bptr != NULL;
}

static void print_binding(ptr)
    BNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", bindex - 1);
	return;
    } else {
	print_binding(ptr->next);
	printf("[%c.%d] ", BIN, ptr->index);
	printf("[%c.%d] [%c.%d] ",
	       PRM, ptr->parameter->index, MOD, ptr->bound_to->index);
	print_rlist(ptr->rename, 0);
	printf("\t { }\n");
    }
}

void show_bin()
{
    print_binding(bptr);
}

void clear_bin()
{
    BNODE *tmp, *next;

    for (tmp = bptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	/* They refer to parts of other structures.
	    Do not free them here, 'cos they are freed somewhere else.
	PSF_FREE(tmp->parameter);
	PSF_FREE(tmp->bound_to);
	*/
	PSF_FREE(tmp);
    }
    bptr = NULL;
    bindex = 1;
}
