%{

/*
 * the YACC grammar for the PSF parser
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"
#include "errordet.h"
#include "global.h" 
#include "main.h"
#include "tabtypes.h"
#include "yimports.h"

char *module_name;       /* module name, for error messages */

static int parenthesis_level = 0;
static int save_state;
static bool in_set_of_atoms = FALSE;
static bool save_in_set_of_atoms;

#define NEW_NODE(id, left, right, child, ntype, stype, ptr, arity)	\
	new_node(id, (TNODE*) left, (TNODE*) right, (TNODE*) child,	\
			ntype, (FANODE *) stype, (SNODE *) ptr, arity)

void on_syntax_err PROTO_ARGS((void));
static void paren_in PROTO_ARGS((void));
static void paren_out PROTO_ARGS((void));

%}

%start	specification

%union	{ 
		char		*literal;
		struct aanode	*atomarg;
		struct pranode  *proarg;
		struct tnode	*termptr;
		struct {
			struct tnode	*lhs;
			struct tnode	*rhs;
		      } eq_couple;
		char		p_exp_type;
	}	

%token DATA_SYM MODULE_SYM BEGIN_SYM END_SYM PARAMETERS_SYM EXPORTS_SYM 
%token IMPORTS_SYM RENAMED_SYM BY_SYM ARROW_SYM BOUND_SYM TO_SYM SORTS_SYM 
%token FUNCTIONS_SYM VARIABLES_SYM EQUATIONS_SYM WHEN_SYM IMPLIES_SYM
%token PROCESS_SYM ATOMS_SYM PROCESSES_SYM SETS_SYM OF_SYM IN_SYM MERGE_SYM
%token COMMUNICATIONS_SYM FOR_SYM DEFINITIONS_SYM SKIP_SYM DELTA_SYM
%token GEN_MERGE_SYM SUM_SYM ENCAPS_SYM HIDE_SYM
%token INTR_SYM DISR_SYM PRIO_SYM CHAIN_SYM
%token STAR_SYM SHARP_SYM

%token	<literal>	IDENTIFIER_SYM
%token	<literal>	OPERATOR_SYM

%type	<literal>	ident_or_operator operator
%type	<literal>	tag

%type	<atomarg>	atom_args
%type	<atomarg>	atom_arg

%type	<proarg>	process_args
%type	<proarg>	process_arg

%type	<eq_couple>	equation

%type	<termptr>	set_exp
%type	<termptr>	set_item_list
%type	<termptr>	set_item
%type	<termptr>	communication
%type	<termptr>	atom_exp
%type	<termptr>	term
%type	<termptr>	term_list
%type	<termptr>	primary
%type	<termptr>	process_def_head
%type	<termptr>	process_exp
%type	<termptr>	placeholder
%type	<termptr>	chain
%type	<termptr>	set_identifier

%type	<p_exp_type>	prefix_operator
%type	<p_exp_type>	gen_operator
%type	<p_exp_type>	set_operator

%left	'+'
%left	'\\' MERGE_SYM STAR_SYM SHARP_SYM
%left	'.'
%left	ARROW_SYM

%%


specification
	: {prologue();}
	    module_list
	  {epilogue();}
	;

module_list
	: /* empty */
	| module_list module 
	;

module
	: DATA_SYM
	  MODULE_SYM 
	  IDENTIFIER_SYM
		{module_name = $3;}
	  BEGIN_SYM
		{set_tag_flag(PARAMETER);}
	  data_parameters
		{set_tag_flag(EXPORTS);}
	  data_exports
		{set_tag_flag(IDLE);}
	  imports 
	  sorts 
	  functions 
	  variables 
		{set_tag_flag(IMPORTS);}
	  equations
	  END_SYM 
	  IDENTIFIER_SYM
		{print_MTIL_module($3,$18,'d');}
	| PROCESS_SYM 
	  MODULE_SYM 
	  IDENTIFIER_SYM 
		{module_name = $3;}
	  BEGIN_SYM
		{set_tag_flag(PARAMETER);}	
	  process_parameters
		{set_tag_flag(EXPORTS);}	
	  process_exports
		{set_tag_flag(IDLE);}	
	  imports 
	  atoms 
	  processes 
	  sets 
		{set_tag_flag(IMPORTS);}
	  communications 
		{set_tag_flag(IDLE);}	
	  variables 
		{set_tag_flag(IMPORTS);}
	  definitions
	  END_SYM 
	  IDENTIFIER_SYM
		{print_MTIL_module($3,$22,'p');}
	;

data_parameters
	: PARAMETERS_SYM data_parameter_list
	| /* empty */
	;

data_parameter_list
	: data_parameter
	| data_parameter_list ',' data_parameter
	;

data_parameter
	: IDENTIFIER_SYM
		{ins_par($1,IDLE);}
	  BEGIN_SYM
		{begin_par_sort();}
	  sorts
		{end_par_sort();}
	  functions 
	  END_SYM IDENTIFIER_SYM
		{check_parameter_ids($1,$9);}
	;

process_parameters
	: PARAMETERS_SYM process_parameter_list
	| /* empty */
	;

process_parameter_list
	: process_parameter
	| process_parameter_list ',' process_parameter
	;

process_parameter
	: IDENTIFIER_SYM
		{ins_par($1,IDLE);}
	  BEGIN_SYM
		{begin_par_sort();}
	  sorts
		{end_par_sort();}
	  functions atoms processes par_sets 
	  END_SYM IDENTIFIER_SYM
	;

data_exports
	: EXPORTS_SYM BEGIN_SYM
	    sorts functions 
	  END_SYM 
	| /* empty */
	;

process_exports
	: EXPORTS_SYM BEGIN_SYM
	    atoms processes sets
	  END_SYM 
	| /* empty */
	;

imports
	: IMPORTS_SYM 
	    module_expression_list
	| /* empty */ 
	;

module_expression_list
	: module_expression
	| module_expression_list ',' module_expression
	;

module_expression
	: IDENTIFIER_SYM
		{ins_mod($1);
		 ins_imp($1);}
	| IDENTIFIER_SYM '{'
		{ins_mod($1);
		 ins_imp($1);}
	  modifier '}'
	;

modifier
	: renamed	
		{ first_modifier(REN); }
	| renamed bound_list
		{ first_modifier(REN); }
	| bound_list
		{ first_modifier(BIN); }
	| bound_list renamed
		{ first_modifier(BIN); }
	;

renamed
	: RENAMED_SYM BY_SYM renamings 
	;

renamings
	: '[' renaming_list ']' 
	;

renaming_list
	: renaming
	| renaming_list ',' renaming
	;

renaming
	: ident_or_operator ARROW_SYM 
	ident_or_operator
	{add_renaming($1,$3);}
	;

ident_or_operator
	: IDENTIFIER_SYM 	{$$ = $1;}
	| operator '_' 	{$$ = unary_op($1);}
	| '_' operator '_'	{$$ = binary_op($2);}
	;

bound_list
	: bound
	| bound_list bound
	;

bound
	: IDENTIFIER_SYM
	  BOUND_SYM TO_SYM IDENTIFIER_SYM
		{ins_par($1,IMPORTS);
		 ins_mod($4);
		 add_binding($1);
		 binding_done($4);} 
	| IDENTIFIER_SYM
	  BOUND_SYM BY_SYM 
		{ins_par($1,IMPORTS);
		 add_binding($1);}
	  renamings TO_SYM IDENTIFIER_SYM
		{ins_mod($7);
		 binding_done($7);}
	;

sorts
	: SORTS_SYM sort_list
	| /* empty */ 
	;

sort_list
	: IDENTIFIER_SYM {ins_sort($1);}
	| sort_list ',' IDENTIFIER_SYM
	      {ins_sort($3);}
	;

functions
	: FUNCTIONS_SYM
	  function_list
	| /* empty */
	;

function_list
	: /* empty function */
	| function_list function
	;

function
	: IDENTIFIER_SYM ':' 		{ins_fun($1);}
	    input_type ARROW_SYM 	{set_fun_arity();} 
	    output_type 
	| operator '_' ':' 		{ins_fun(unary_op($1));}
  	    IDENTIFIER_SYM 		{add_fun_sort($5);} 
	    ARROW_SYM 			{set_fun_arity();} 
	    output_type
	| '_' operator '_' ':' 	{ins_fun(binary_op($2));}
	    IDENTIFIER_SYM 		{add_fun_sort($6);} 
	    '#'
	    IDENTIFIER_SYM 		{add_fun_sort($9);} 
	    ARROW_SYM 			{set_fun_arity();} 
	    output_type
	| error
	;

input_type
	: product
	| /* empty */ 
	;

output_type
	: IDENTIFIER_SYM {add_fun_sort($1);}
	;

product
	: IDENTIFIER_SYM {add_fun_sort($1);}
	| product '#' IDENTIFIER_SYM {add_fun_sort($3);}
	;

atoms
	: ATOMS_SYM atom_list
	| /* empty */	
	;

atom_list
	: /* empty atom_decl */
	| atom_list atom_decl
	;

atom_decl
	: IDENTIFIER_SYM ','
		{ins_atm_not_last($1);} 
	  atom_decl
	| IDENTIFIER_SYM
		{ins_atm_last($1,(struct aanode *)NULL);} 
        | IDENTIFIER_SYM ':' atom_args
		{ins_atm_last($1,$3);}
	| error
	;

atom_args
	: atom_arg
	| error  {}
	;

atom_arg
	: IDENTIFIER_SYM
		{$$ = add_atm_sort((struct aanode *)NULL,$1);}
	| atom_arg '#' IDENTIFIER_SYM
		{$$ = add_atm_sort($1,$3);}
	;

processes
	: PROCESSES_SYM process_list
	| /* empty */	
	;

process_list
	: /*empty process_decl */
	| process_list process_decl
	;

process_decl
	: IDENTIFIER_SYM ','
		{ins_pro_not_last($1);} 
	  process_decl
	| IDENTIFIER_SYM
		{ins_pro_last($1,(struct pranode *)NULL);} 
        | IDENTIFIER_SYM ':' process_args
		{ins_pro_last($1,$3);}
	| error
	;

process_args
	: process_arg
	| error	{}
	;

process_arg
	: IDENTIFIER_SYM
		{$$ = add_pro_sort((struct pranode *)NULL,$1);}
	| process_arg '#' IDENTIFIER_SYM
		{$$ = add_pro_sort($1,$3);}
	;

par_sets
	: SETS_SYM 
		{begin_process_term();}
	  par_set_defs_list
		{begin_rest();}
	| /* empty */
	;

par_set_defs_list
	: /* empty par_set_defs */
	| par_set_defs_list par_set_defs
	;

par_set_defs
	: OF_SYM identifier_or_atoms par_set_definition_list
	| error
	;

par_set_definition_list
	: /* empty par_set_definition */
	| par_set_definition_list par_set_definition
	;

par_set_definition
	: IDENTIFIER_SYM 
		{ ins_set($1,(TNODE *)NULL,get_set_sort()); }
	;

sets
	: SETS_SYM 
		{ begin_process_term(); }
	  set_defs_list
		{ begin_rest(); }
	| /* empty */
	;

set_defs_list
	: /* empty set_defs */
	| set_defs_list set_defs
	;

set_defs
	: OF_SYM identifier_or_atoms set_definition_list
		{ in_set_of_atoms = FALSE; }
	| error
	;

identifier_or_atoms
	: IDENTIFIER_SYM
		{ 
		  push_tag_flag();
		  set_tag_flag(IMPORTS);
		  set_set_sort($1);
		  set_tag_flag(pop_tag_flag());
		  in_set_of_atoms = FALSE;
		}
	| ATOMS_SYM
		{ set_set_sort((char *)NULL);
		  in_set_of_atoms = TRUE;
		}
	;

set_definition_list
	: /* empty set_definition */
	| set_definition_list set_definition
	;

set_definition
	: IDENTIFIER_SYM '=' 
		{ 
		  push_tag_flag();
		  set_tag_flag(IMPORTS); }
	  set_exp
		{ set_tag_flag(pop_tag_flag()); 
		  ins_set($1,$4,get_set_sort()); }
	;

set_exp
	: IDENTIFIER_SYM
                { if (get_set_sort() == NULL)
		      $$ = NEW_NODE($1,NULL,NULL,NULL,SET,NULL,NULL,0);
		  else if (strcmp(get_set_sort()->id,$1) != 0)
                      /*
                       * If there is no set with this name, it is a
                       * known sort or it is an unknown sort or set.
                       */
                      if (lookup_set($1) == NULL)
                          $$ = NEW_NODE($1,NULL,NULL,NULL,SOR,NULL,NULL,0);
                      else
                          $$ = NEW_NODE($1,NULL,NULL,NULL,SET,NULL,NULL,0);
		  else
		      $$ = NEW_NODE($1,NULL,NULL,NULL,SOR,NULL,NULL,0); 
		}
	| ATOMS_SYM {
		$$ = NEW_NODE("atoms",NULL,NULL,NULL,ATOMSET,NULL,NULL,0);
	    }
	| '{'
		{ begin_set_item();}
	    set_item_list enum_cont 
                { $$ = NEW_NODE(",",NULL,NULL,$3,ENU,NULL,NULL,sibling_cnt($3));
		  type_tree($3,SET);
		  phs_out_of_scope();
		  begin_process_term();
		}
	| '{' enum_cont 
                { $$ = NEW_NODE(",",NULL,NULL,NULL,ENU,NULL,NULL,0);
                  /*empty set {} MarkVW */ }
	| set_exp '+' set_exp
                { $$ = NEW_NODE("+",NULL,NULL,$1,UNI,NULL,NULL,2);
		  $1->right = $3;
		  $3->left = $1; }
	| set_exp '.' set_exp
                { $$ = NEW_NODE(".",NULL,NULL,$1,INT,NULL,NULL,2);
		  $1->right = $3;
		  $3->left = $1; }
	| set_exp '\\' set_exp
                { $$ = NEW_NODE("\\",NULL,NULL,$1,DIF,NULL,NULL,2);
		  $1->right = $3;
		  $3->left = $1; }
	| '(' set_exp ')'
		{ $$ = $2; }
	;

enum_cont
	: '}'
	| '|'  placeholder_list '}'
	;

set_item_list
	: set_item
		{ $$ = $1; }
	|  set_item_list ',' set_item
		{ $3->left = last_sibling($1);
		  $3->left->right = $3;
		  $$ = $1; }
	| error
	      { $$ = NEW_NODE("Syntax Error",NULL,NULL,NULL,UND,NULL,NULL,0); }
	;

set_item
	: term
	;

placeholder_list
	: placeholder {}
	| placeholder_list ',' placeholder
	| error
	;

placeholder
	: IDENTIFIER_SYM IN_SYM IDENTIFIER_SYM
		{ ins_var_last(LOCAL,$1,$3);
		  ins_ph($1);
		  $$ = NEW_NODE($1,NULL,NULL,NULL,VAR,NULL,lookup_ph($1),0); }
	;

communications
	: COMMUNICATIONS_SYM 
		{ begin_process_term(); }
	  communication_def_list
		{ begin_rest(); }
	| /* empty */
	;

communication_def_list
	: /* empty communication_def */
	| communication_def_list communication_def
	| error
	;

communication_def
	: communication
		{ type_comm($1); }
	| communication FOR_SYM placeholder_list
		{ type_comm($1);
		  phs_out_of_scope(); }
	;

communication
	: atom_exp '|' atom_exp '=' atom_exp
                { $$ = NEW_NODE("|",NULL,NULL,$1,COM,NULL,NULL,3);
		  $1->right = $3;
		  $3->right = $5;
		  $5->left = $3;
		  $3->left = $1; }
	;

atom_exp
	: IDENTIFIER_SYM 
                { $$ = NEW_NODE($1,NULL,NULL,NULL,ATM,NULL,NULL,0); }
	| IDENTIFIER_SYM 
	  '('
	  term_list
	  ')' 
                { $$ = NEW_NODE($1,NULL,NULL,$3,ATM,NULL,NULL,sibling_cnt($3)); 
		  }
	;

variables
	: VARIABLES_SYM variable_list
	| /* empty */
	;

variable_list
	: /* empty var_decl  */
	| variable_list var_decl 
	;

var_decl
        : IDENTIFIER_SYM ':' ARROW_SYM IDENTIFIER_SYM 
		{ins_var_last(IDLE,$1,$4);}
	| IDENTIFIER_SYM ',' 
		{ins_var(IDLE,$1);} var_decl
	| error
	;

equations
	: EQUATIONS_SYM 
	  equation_list
	| /* empty */
	;

equation_list
	: /* empty cond_equation */
	| equation_list cond_equation
	;

cond_equation
	: tag equation_series IMPLIES_SYM equation
		{ ins_equ($1,$4.lhs,$4.rhs); }
	| tag equation
		{ ins_equ($1,$2.lhs,$2.rhs); }
	| tag equation WHEN_SYM equation_series
		{ ins_equ($1,$2.lhs,$2.rhs); }
	;

tag
	: '[' IDENTIFIER_SYM ']'
		{ $$ = $2;}
	;

equation_series
	: equation
		{ ins_equ_cond($1.lhs,$1.rhs); }
	| equation_series ',' equation
		{ ins_equ_cond($3.lhs,$3.rhs); }
	;

equation
	: term '=' term
		{ 
		  type_tree($1,EQU);
		  type_tree($3,EQU);
		  $$.lhs = $1;
		  $$.rhs = $3; }
	;

definitions
	: DEFINITIONS_SYM 
	  { begin_process_term(); }
	  process_def_list 
	  { begin_rest(); }
	| /* empty */
	;

process_def_list
	: /* empty process_def */
	| process_def_list process_def
	;

process_def
	: process_def_head '=' process_exp 
		{ type_tree($1,PDL);
		  type_tree($3,PDR);
		  ins_pdf($1,$3); }
	;

process_def_head
	: IDENTIFIER_SYM 
                { $$ = NEW_NODE($1,NULL,NULL,NULL,PRO,NULL,NULL,0); }
	| IDENTIFIER_SYM 
	  '('
		{ paren_in(); }
	  term_list
	  ')' 
                { paren_out();
                  $$ = NEW_NODE($1,NULL,NULL,$4,PRO,NULL,NULL,sibling_cnt($4));
		}
	;

process_exp
	: SKIP_SYM
                { $$ = NEW_NODE("skip",NULL,NULL,NULL,SKP,NULL,NULL,0); }
	| DELTA_SYM
		{ $$ = NEW_NODE("delta",NULL,NULL,NULL,DLK,NULL,NULL,0); }
	| IDENTIFIER_SYM 
                { $$ = NEW_NODE($1,NULL,NULL,NULL,UAP,NULL,NULL,0); }
	| IDENTIFIER_SYM 
	  '(' 
		{ paren_in(); }
	  term_list
	  ')' 
                { paren_out();
                  $$ = NEW_NODE($1,NULL,NULL,$4,UAP,NULL,NULL,sibling_cnt($4));
		}
	| process_exp '.' process_exp
                { $$ = NEW_NODE(".",NULL,NULL,$1,SEQ,NULL,NULL,2);
		  $1->right = $3;
		  $3->left = $1; }
	| process_exp '+' process_exp
                { $$ = NEW_NODE("+",NULL,NULL,$1,ALT,NULL,NULL,2);
		  $1->right = $3;
		  $3->left = $1; }
	| process_exp MERGE_SYM process_exp
                { $$ = NEW_NODE("||",NULL,NULL,$1,PAR,NULL,NULL,2);
		  $1->right = $3;
		  $3->left = $1; }
	| process_exp STAR_SYM process_exp
                { $$ = NEW_NODE("*",NULL,NULL,$1,STAR,NULL,NULL,2);
		  $1->right = $3;
		  $3->left = $1; }
	| process_exp SHARP_SYM process_exp
                { $$ = NEW_NODE("#",NULL,NULL,$1,SHARP,NULL,NULL,2);
		  $1->right = $3;
		  $3->left = $1; }
	| prefix_operator '(' process_exp ',' process_exp ')' {
		$$ = NEW_NODE("int", NULL, NULL, $3, $1, NULL, NULL, 2);
		$3->right = $5;
		$5->left = $3;
	    }
	| gen_operator '(' placeholder ',' process_exp ')'
                { $$ = NEW_NODE("gen",NULL,NULL,$3,$1,NULL,NULL,2);
		  $3->right = $5;
		  $5->left = $3;
		  var_out_of_scope(); }
	| set_operator '(' set_identifier ',' process_exp ')'
                { $$ = NEW_NODE("set",NULL,NULL,$3,$1,NULL,NULL,2);
		  $3->right = $5;
		  $5->left = $3; }
	| PRIO_SYM '(' chain ',' process_exp ')' {
		$$ = NEW_NODE("prio",NULL,NULL,$3,PRIO,NULL,NULL,2);
		$3->right = $5;
		$5->left = $3;
	    }
	| '(' process_exp ')'
		{ $$ = $2; }
	| '[' 
	  equation
	  ']' ARROW_SYM process_exp 
                { $$ = NEW_NODE("guard",NULL,NULL,$2.lhs,GRD,NULL,NULL,0);
		  $2.lhs->right = $2.rhs;
		  $2.rhs->right = $5;
		  $5->left = $2.rhs;
		  $2.rhs->left = $2.lhs; } 
	;

prefix_operator :
	    INTR_SYM {
		$$ = INTR;
	    }
	|   DISR_SYM {
		$$ = DISR;
	    }
;

gen_operator
	: SUM_SYM
		{ $$ = SUM; }
	| GEN_MERGE_SYM
		{ $$ = MRG; }
	;

set_operator
	: ENCAPS_SYM
		{ $$ = ENC; }
	| HIDE_SYM
		{ $$ = HID; }
	;

chain :
	    set_identifier {
		$$ = NEW_NODE("chain", NULL, NULL, $1, CHAIN, NULL, NULL, 1);
	    }
	|   chain CHAIN_SYM set_identifier {
		struct tnode *h;
		$$ = NEW_NODE("chain", NULL, NULL, $1->child, CHAIN, NULL, NULL,
		    $1->arity + 1);
		for (h = $1->child; h->right != NULL; h = h->right);
		h->right = $3;
		$3->left = h;
	    }
;

set_identifier :
	    IDENTIFIER_SYM {
		$$ = NEW_NODE($1, NULL, NULL, NULL, SET, NULL, NULL, 0);
	    }
	|   ATOMS_SYM {
		$$ = NEW_NODE("atoms", NULL, NULL, NULL, ATOMSET, NULL, NULL, 0);
	    }
;

term
	: primary
		{ $$ = $1; }
	| term operator primary
                { $$ = NEW_NODE(binary_op($2),NULL,NULL,$1,FUN,NULL,NULL,2); 
		  $$->child = $1;
		  $1->right = $3;
		  $3->left = $1; }
	;

primary
	: IDENTIFIER_SYM
                { VNODE *tmp;
		  if ((tmp = lookup_var($1,UNKNOWN)) != NULL) 
		    $$ = NEW_NODE($1,NULL,NULL,NULL,VAR,NULL,tmp,0);
		  else if (in_set_of_atoms)
		    $$ = NEW_NODE($1,NULL,NULL,NULL,ATM,NULL,NULL,0);
		  else
		    $$ = NEW_NODE($1,NULL,NULL,NULL,UVF,NULL,NULL,0);
		}
	| IDENTIFIER_SYM '('
		{ paren_in(); }
	  term_list
	  ')'
                { paren_out();
		  if (in_set_of_atoms)
		    $$ = NEW_NODE($1,NULL,NULL,$4,ATM,NULL,NULL,
					sibling_cnt($4));
		  else
		    $$ = NEW_NODE($1,NULL,NULL,$4,FUN,NULL,NULL,
					sibling_cnt($4));
		}
	| operator primary
                { $$ = NEW_NODE(unary_op($1),NULL,NULL,$2,FUN,NULL,NULL,2); }
	| '('
		{ paren_in(); }	
	  term
	  ')'
		{ paren_out(); $$ = $3; }
	;

term_list
	: term
		{ $$ = $1; }
	| term_list ',' term
		{ $3->left = last_sibling($1);
		  $3->left->right = $3;
		  $$ = $1; }
	| error
	      { $$ = NEW_NODE("Syntax Error",NULL,NULL,NULL,UND,NULL,NULL,0); }
	;

operator	: OPERATOR_SYM
		;

%%

static void paren_in()
{ if (parenthesis_level++ == 0) {
	save_state=state;
	save_in_set_of_atoms = in_set_of_atoms;
	in_set_of_atoms = FALSE;
	begin_rest();
  }
}

static void paren_out()
{ if (--parenthesis_level == 0) {
	restore_state(save_state);
	in_set_of_atoms = save_in_set_of_atoms;
  }
}

void on_syntax_err()
{
    errorseen = TRUE;
}
