%{
/*============================================================================*
 *									      *
 *	file: psf.l							      *
 *      info: lexical definitions for lex to generate a lexical analyser      *
 * 	      for algebraic specifications written in PSFd 		      *
 *									      *
 *============================================================================*/

/* #include <stdio.h>   -- already included by lex; makedepend objects to
			-- including it twice */
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "main.h"
#include "y.tab.h"

#include "tabtypes.h"
#include "yimports.h"

#define yywrap() 1
/* and to keep it all compatible with flex */
#define YY_SKIP_YYWRAP

int state = 0;

%}

id_char		[A-Za-z0-9\']
op_symbol	[!@$%\^&+\-*;?~/|\\]
special_op_symbol [><=:]
ident		{id_char}(({id_char}|-)*{id_char})?
operator	({op_symbol}+)|(\.{ident}\.)|(({special_op_symbol}|{op_symbol})({special_op_symbol}|{op_symbol})+)
newline		[\r\f\n]
layout		[ \t]
commentchar	[^\n\r\f\-]
comment		--(-?{commentchar})*(--|-?{newline})

si_op_symbol	[!@$%\^&+\-*;?~/\\]
si_op    	({si_op_symbol}+)|(\.{ident}\.)|(({special_op_symbol}|{si_op_symbol})({special_op_symbol}|{si_op_symbol})+)

%START process_term set_item rest

%%

{layout}{comment}       |
{newline}{comment}	|
^{comment}              |
{newline}		|
{layout}		;

"data"			return(DATA_SYM);
"process"		return(PROCESS_SYM);
"module"		return(MODULE_SYM);
"begin"			return(BEGIN_SYM);
"end"			return(END_SYM);
"parameters"		return(PARAMETERS_SYM);
"exports"		return(EXPORTS_SYM);
"imports"		return(IMPORTS_SYM);
"renamed"		return(RENAMED_SYM);
"by"			return(BY_SYM);
"->"			return(ARROW_SYM);
"bound"			return(BOUND_SYM);
"to"			return(TO_SYM);
"sorts"			return(SORTS_SYM);
"functions"		return(FUNCTIONS_SYM);
"atoms"			return(ATOMS_SYM);
"processes"		return(PROCESSES_SYM);
"sets"			return(SETS_SYM);
"communications"	return(COMMUNICATIONS_SYM);
"for"			return(FOR_SYM);
"of"			return(OF_SYM);
"in"			return(IN_SYM);
"variables"		return(VARIABLES_SYM);
"equations"		return(EQUATIONS_SYM);
"when"			return(WHEN_SYM);
"definitions"		return(DEFINITIONS_SYM);
"skip"			return(SKIP_SYM);
"delta"			return(DELTA_SYM);
"merge"			return(GEN_MERGE_SYM);
"sum"			return(SUM_SYM);
"encaps"		return(ENCAPS_SYM);
"hide"			return(HIDE_SYM);
"interrupt"		return(INTR_SYM);
"disrupt"		return(DISR_SYM);
"prio"			return(PRIO_SYM);
">"			return(CHAIN_SYM);

{ident}			{ yylval.literal = psf_strdup(yytext);
			  return(IDENTIFIER_SYM);
			}

<rest>{operator}	|
<set_item>{si_op}	{ yylval.literal = psf_strdup(yytext);
			  return(OPERATOR_SYM);
			}

<process_term>"||"	return(MERGE_SYM);
<process_term>"*"	return(STAR_SYM);
<process_term>"#"	return(SHARP_SYM);

==(=)*>?		return(IMPLIES_SYM);
.			{
			  return( yytext[0]);
			}	
%%

void begin_process_term()
{
    BEGIN process_term;
    state = process_term;
}

void begin_set_item()
{
    BEGIN set_item;
    state = set_item;
}

void begin_rest()
{
    BEGIN rest;
    state = rest;
}

void restore_state(oldstate)
    int oldstate;
{
    BEGIN oldstate;
    state = oldstate;
}
