/*
 * routines to access the process table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"

PRNODE *prptr = NULL;
static int prindex = 1;

#define	ARITY_UNKNOWN	(-1)

void init_pro_table()
{
    prptr = NULL;
}

static void insert_pro(id, arity)
    char *id;
    int arity;
{
    PRNODE *tmp;

    tmp = PSF_MALLOC(PRNODE);
    tmp->id = psf_strdup(id);
    tmp->index = prindex++;
    tmp->tag = get_tag_flag();
    tmp->arity = arity;
    tmp->arg = NULL;
    tmp->next = prptr;
    prptr = tmp;

    if (get_tag_flag() == PARAMETER)
	ins_par_item(PRO, tmp->index);
}

void ins_pro(id)
    char *id;
{
    insert_pro(id, 0);
}

void ins_pro_not_last(id)
    ID id;
{
    insert_pro(id, ARITY_UNKNOWN);
    /* arg and arity will be filled in later by ins_pro_last() */
}

static int len_prarg(arg)
    PRANODE *arg;
{
    PRANODE *tmp;
    int len = 0;

    for (tmp = arg; tmp != NULL; tmp = tmp->next)
	len++;
    return (len);
}

void ins_pro_last(id, arg)
    ID id;
    PRANODE *arg;
{
    PRNODE *tmp;

    insert_pro(id, len_prarg(arg));
    prptr->arg = arg;

    for (tmp = prptr->next; tmp != NULL; tmp = tmp->next)
	if (tmp->arity == ARITY_UNKNOWN) {
	    tmp->arg = prptr->arg;
	    tmp->arity = prptr->arity;
	} else
	    break;
}

static PRANODE *append_prarg(arg1, arg2)
    PRANODE *arg1, *arg2;
{
    PRANODE *tmp;

    if ((tmp = arg1) != NULL) {
	tmp->next = arg2;
	return (arg1);
    } else
	return (arg2);
}

PRANODE *add_pro_sort(arg, id)
    PRANODE *arg;
    ID id;
{
    PRANODE *tmp;

    tmp = PSF_MALLOC(PRANODE);
    if ((tmp->arg = lookup_sort(id)) == NULL)	/* sort not yet in table */
	tmp->arg = ins_sort_tag(id, UNKNOWN);

    return (append_prarg(tmp, arg));
}

void add_pro_sort_ptr(sor_ptr)
    SNODE *sor_ptr;
{
    PRANODE *tmp;

    tmp = PSF_MALLOC(PRANODE);
    prptr->arity++;
    tmp->arg = sor_ptr;
    tmp->next = prptr->arg;
    prptr->arg = tmp;
}

PRNODE *lookup_pro(id)
    char *id;
{
    PRNODE *tmp;

    for (tmp = prptr; tmp != NULL; tmp = tmp->next)
	if (strcmp(tmp->id, id) == 0)
	    return (tmp);
    return (NULL);
}

BOOL pro_present()
{
    return prptr != NULL;
}

static void print_prarg(ptr)
    PRANODE *ptr;
{
    if (ptr == NULL)
	return;
    else {
	print_prarg(ptr->next);
	if (ptr->arg != NULL)
	    printf("[%c.%d] ", SOR, ptr->arg->index);
	else
	    printf("[%c.?] ", SOR);
    }
}

static void print_pro(ptr)
    PRNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", prindex - 1);
	return;
    } else {
	print_pro(ptr->next);
	printf("[%c.%d] %c %d ", PRO, ptr->index, ptr->tag, ptr->arity);
	print_prarg(ptr->arg);
	printf(" \t{ %s }\n", ptr->id);
    }
}

void show_pro()
{
    print_pro(prptr);
}

static void clear_prarg_list(ptr)
    PRANODE *ptr;
{
    PRANODE *tmp, *next;

    for (tmp = ptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp);
    }
}

void clear_pro()
{
    PRNODE *tmp, *next;

    for (tmp = prptr; tmp != NULL; tmp = next) {
	clear_prarg_list(tmp->arg);
	next = tmp->next;
	PSF_FREE(tmp->id);
	PSF_FREE(tmp);
    }

    prptr = NULL;
    prindex = 1;
}
