/*
 * routines to access the process definition table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"

static DNODE *dptr = NULL;
static int dindex = 1;

void init_pdf_table()
{
    dptr = NULL;
}

void ins_pdf(lptr, rptr)
    struct tnode *lptr, *rptr;
{
    DNODE *tmp_ptr;

    tmp_ptr = PSF_MALLOC(DNODE);

    tmp_ptr->index = dindex++;
    tmp_ptr->lhs = lptr;
    tmp_ptr->rhs = rptr;

    tmp_ptr->next = dptr;
    dptr = tmp_ptr;
}

BOOL pdf_present()
{
    return dptr != NULL;
}

static void print_pdf(ptr)
    DNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", dindex - 1);
	return;
    } else {
	print_pdf(ptr->next);
	printf("[%c.%d] ", DEF, ptr->index);
	print_node(ptr->lhs);
	printf(" = ");
	print_node(ptr->rhs);
	printf(" \t{ }\n");
    }
}

void show_pdf()
{
    print_pdf(dptr);
}

void clear_pdf()
{
    DNODE *tmp_ptr, *next;

    for (tmp_ptr = dptr; tmp_ptr != NULL; tmp_ptr = next) {
	next = tmp_ptr->next;
	clear_tree(tmp_ptr->rhs);
	clear_tree(tmp_ptr->lhs);
	PSF_FREE(tmp_ptr);
    }

    dptr = NULL;
    dindex = 1;
}
