/*
 * routines to access the parameter table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

PNODE *pptr = NULL;

static int pindex = 1;
static BOOL par_sort = FALSE;	/* TRUE if parsing sorts in a parameter */

void init_par_table()
{
    pptr = NULL;
}

void begin_par_sort()
{
    par_sort = TRUE;
}

void end_par_sort()
{
    par_sort = FALSE;
}

BOOL par_sort_flag()
{
    return par_sort;
}

void ins_par(id, tag)
    char *id;
    TAG tag;
{
    PNODE *tmp;

    tmp = PSF_MALLOC(PNODE);
    tmp->index = pindex++;
    tmp->tag = tag;
    tmp->id = psf_strdup(id);
    tmp->item = NULL;
    tmp->next = pptr;
    pptr = tmp;
}

PNODE *lookup_par(id)
    char *id;
{
    PNODE *tmp;

    for (tmp = pptr; tmp != NULL; tmp = tmp->next)
	if (strcmp(tmp->id, id) == 0)
	    return (tmp);

    return (NULL);
}

void ins_par_item(type, index)
    char type;
    int index;
{
    PANODE *tmp;

    tmp = PSF_MALLOC(PANODE);
    tmp->index = index;
    tmp->type = type;
    tmp->next = pptr->item;
    pptr->item = tmp;
}

static void print_par_item(ptr, cnt)
    PANODE *ptr;
    int cnt;
{
    if (ptr == NULL) {
	printf("%d ", cnt);
	return;
    } else {
	print_par_item(ptr->next, cnt + 1);
	printf("[%c.%d] ", ptr->type, ptr->index);
    }
}


BOOL par_present()
{
    return pptr != NULL;
}

static void print_par(ptr)
    PNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", pindex - 1);
	return;
    } else {
	print_par(ptr->next);
	printf("[%c.%d] %c ", PRM, ptr->index, ptr->tag);
	print_par_item(ptr->item, 0);
	printf("\t{ %s }\n", ptr->id);
    }
}

void show_par()
{
    print_par(pptr);
}

void clear_par()
{
    PNODE *tmp, *next;

    for (tmp = pptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp->id);
	PSF_FREE(tmp);
    }
    pptr = NULL;
    pindex = 1;
}
