/*
 * routines to access the module table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

MNODE *mptr = NULL;

static int mindex = 1;

void init_mod_table()
{
    mptr = NULL;
}

MNODE *ins_mod_straight(id)
    char *id;
{
    MNODE *tmp;

    tmp = PSF_MALLOC(MNODE);
    tmp->index = mindex++;
    tmp->id = psf_strdup(id);
    tmp->next = mptr;
    mptr = tmp;

    return (tmp);
}

MNODE *lookup_mod(id)
    ID id;
{
    MNODE *tmp;

    for (tmp = mptr; tmp != NULL; tmp = tmp->next)
	if (strcmp(tmp->id, id) == 0)
	    return (tmp);

    return (NULL);
}

void ins_mod(id)
    ID id;
{
    if (lookup_mod(id) == NULL)
	(void) ins_mod_straight(id);
}

BOOL mod_present()
{
    return mptr != NULL;
}

static void print_mod(ptr)
    MNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", mindex - 1);
	return;
    } else {
	print_mod(ptr->next);
	printf("[%c.%d] \t{ %s }\n", MOD, ptr->index, ptr->id);
    }
}

void show_mod()
{
    print_mod(mptr);
}

void clear_mod()
{
    MNODE *tmp, *next;

    for (tmp = mptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp);
    }
    mptr = NULL;
    mindex = 1;
}
