#include <stdio.h>
#include <string.h>

#include "psf_prototype.h"
#include "env_variables.h"
#include "psf_exits.h"
#include "psf_fopen.h"
#include "psf_malloc.h"
#include "psf_redefs.h"
#include "psf_standards.h"
#include "version.h"
#include "main.h"

#include "global.h"
#include "tabtypes.h"
#include "yimports.h"

extern FILE *yyin;		/* input FILE from lex */
extern int yylineno;		/* line number from lex */

bool errorseen = FALSE;		/* flags grammatical/semantical errors */
char *progname;			/* for error messages */
char *filename;			/* for error messages */

static void version()
{
    (void) fprintf(stderr, "psf_mtil version %s, last compiled %s\n",
		   VERSION, __DATE__);
}

static void usage()
{
    (void) fprintf(stderr, "usage: %s [-vh] [input] \n", progname);
}

int main(argc, argv)
    int argc;
    char **argv;
{
    int i, c;
    bool v_opt = FALSE;
    psf_file pf;
    static suffix suffixes[] = {{PSFSUFFIX, PSFSUFFIX_DEFAULT}, {NULL, NULL}};

    if (argc == 0) {
	(void) fprintf(stderr, "who am I ?\n");
	exit(EXIT_HELP);
    }
    progname = psf_basename(argv[0]);

    while ((c = getopt(argc, argv, "hv")) != EOF)
	switch (c) {
	case 'v':
	    version();
	    v_opt = TRUE;
	    break;
	case 'h':
	    usage();
	    exit(EXIT_SUCCESS);
	    break;
	default:
	    usage();
	    exit(EXIT_CMD_LINE_ERR);
	}

    if (optind == argc) {
	filename = "stdin";
	if (yyparse())
	    exit(EXIT_SYNTAX_ERR);
    } else
	for (i = optind; i < argc; i++) {
	    pf = psf_fopen(argv[i], suffixes);
	    yyin = pf.fp;
	    filename = pf.name;
	    if (v_opt)
		(void) fprintf(stderr, "%s: reading from %s\n",
					progname, filename);
	    if (yyparse())
		exit(EXIT_SYNTAX_ERR);
	}

    return errorseen?EXIT_SYNTAX_ERR:EXIT_SUCCESS;
}
