/*
 * include file for the global definitions used by the PSF parser
 */

typedef char TAG;
typedef char *ID;
typedef int BOOL;

#define TRUE		1
#define FALSE		0

#define	IDLE		'_'
#define IMPORTS		'?'
#define	EXPORTS		'!'
#define PARAMETER	'@'
#define	LOCAL		'#'
#define UNKNOWN	'$'	/* clash: atom/process or set/sort or var/ph */

#define UND	'*'		/* undefined */
#define TUP	'T'		/* tuple */
#define PDL	'<'		/* process definition head LHS */
#define PDR	'>'		/* process definition head RHS */
#define UAP	'$'		/* undefined atom or process */
#define USS	'^'		/* undefined sort or set */
#define UVF	'~'		/* undefined variable or function */
#define RDS	'&'		/* a sort redefined as set */

#define UNI	'+'		/* union */
#define INT	'.'		/* intersection */
#define DIF	'\\'		/* difference */
#define ENU	':'		/* enumeration */

#define SKP	'i'		/* skip */
#define DLK	'd'		/* delta, deadlock */
#define ALT	'a'		/* alternative composition */
#define SEQ	's'		/* sequential composition */
#define PAR	'p'		/* parallel composition */
#define SUM	'A'		/* generalized sum */
#define MRG	'P'		/* generalized merge */
#define ENC	'e'		/* encapsulation */
#define HID	'h'		/* hiding */
#define GRD	'g'		/* guarded expression */
#define INTR	'I'		/* interrupt */
#define DISR	'D'		/* disrupt */
#define PRIO	'R'		/* priority */
#define CHAIN	'c'		/* chain */
#define STAR	'K'		/* Kleene's star */
#define SHARP	'S'		/* sharp */
#define ATOMSET	'0'		/* atom set */

#define MOD	'M'		/* module */
#define PRM	'P'		/* parameter block */
#define RIT	'U'		/* (undefined) renaming item */
#define REN	'R'		/* renaming */
#define BIN	'B'		/* binding */
#define IMP	'I'		/* import */
#define SOR	'1'		/* sort */
#define FUN	'2'		/* function */
#define ATM	'3'		/* atomic action */
#define PRO	'4'		/* process declaration */
#define SET	'5'		/* set definition */
#define COM	'6'		/* communication */
#define VAR	'7'		/* variables */
#define EQU	'8'		/* equations */
#define DEF	'9'		/* process definitions */
