/*
 * routines to access the function table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"

FNODE *fptr = NULL;

static int findex = 1;
static int arity = 0;		/* input arguments in a function */

void init_fun_table()
{
    fptr = NULL;
}

void ins_fun(id)
    char *id;
{
    FNODE *tmp;

    tmp = PSF_MALLOC(FNODE);
    tmp->index = findex++;
    tmp->tag = get_tag_flag();
    tmp->id = psf_strdup(id);
    tmp->arity = 0;
    arity = 0;
    tmp->arg = NULL;
    tmp->next = fptr;
    fptr = tmp;

    if (get_tag_flag() == PARAMETER)
	ins_par_item(FUN, tmp->index);
}

void set_fun_arity()
{
    fptr->arity = arity;
}

void add_fun_sort_ptr(sor_ptr)
    SNODE *sor_ptr;
{
    FANODE *tmp;

    tmp = PSF_MALLOC(FANODE);
    arity++;
    tmp->arg = sor_ptr;
    tmp->next = fptr->arg;
    fptr->arg = tmp;
}

void add_fun_sort(id)
    ID id;
{
    FANODE *tmp;

    tmp = PSF_MALLOC(FANODE);
    arity++;
    if ((tmp->arg = lookup_sort(id)) == NULL)	/* sort not yet in table */
	tmp->arg = ins_sort_tag(id, IMPORTS);

    tmp->next = fptr->arg;
    fptr->arg = tmp;
}

FNODE *lookup_constant(id)
    char *id;
{
    FNODE *tmp;

    /*
     * printf("looking for <%s>\n",id);
     */

    for (tmp = fptr; tmp != NULL; tmp = tmp->next) {
	/*
	 * printf("found <%s>, arity<%d>\n",tmp->id,tmp->arity);
	 */
	if ((strcmp(tmp->id, id) == 0) && (tmp->arity == 0))
	    return (tmp);
    }

    return (NULL);
}

FNODE *lookup_fun(id)
    char *id;
{
    FNODE *tmp;

    for (tmp = fptr; tmp != NULL; tmp = tmp->next)
	if (strcmp(tmp->id, id) == 0)
	    return (tmp);

    return (NULL);
}

BOOL fun_present()
{
    return fptr != NULL;
}

static int print_farg(ptr, fun_ptr)
    FANODE *ptr;
    FNODE *fun_ptr;
{
    int cnt;

    if (ptr == NULL)
	return (0);
    else {
	if ((cnt = print_farg(ptr->next, fun_ptr)) == fun_ptr->arity)
	    printf("%d ", farg_cnt(fun_ptr) - fun_ptr->arity);
	if (ptr->arg != NULL)
	    printf("[%c.%d] ", SOR, ptr->arg->index);
	else
	    printf("[%c.?] ", SOR);
    }
    return (cnt + 1);
}

static void print_fun(ptr)
    FNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", findex - 1);
	return;
    } else {
	print_fun(ptr->next);
	printf("[%c.%d] %c %d ", FUN, ptr->index, ptr->tag, ptr->arity);
	print_farg(ptr->arg, ptr);
	printf(" \t{ %s }\n", ptr->id);
    }
}

void show_fun()
{
    print_fun(fptr);
}

int farg_cnt(ptr)
    FNODE *ptr;
{
    FANODE *tmp;
    int cnt = 0;

    tmp = ptr->arg;
    for (tmp = ptr->arg; tmp != NULL; cnt++)
	tmp = tmp->next;

    return (cnt);
}

void clear_farg_list(ptr)
    FANODE *ptr;
{
    FANODE *tmp, *next;

    for (tmp = ptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp);
    }
}

void clear_fun()
{
    FNODE *tmp, *next;

    for (tmp = fptr; tmp != NULL; tmp = next) {
	clear_farg_list(tmp->arg);
	next = tmp->next;
	PSF_FREE(tmp->id);
	PSF_FREE(tmp);
    }

    fptr = NULL;
    findex = 1;
}

void dump_fun()
{
    FNODE *tmp;
    FANODE *tmpa;

    printf("*** function table ***\n\n");

    for (tmp = fptr; tmp != NULL; tmp = tmp->next) {
	printf("\nname:\t<%s>\n", tmp->id);
	printf("loc:\t<%lu>\n", (unsigned long)tmp);
	printf("ind:\t<%d>\n", tmp->index);
	printf("tag:\t<%c>\n", tmp->tag);
	printf("arity:\t<%d>\n", tmp->arity);
	printf("next:\t<%lu>\n", (unsigned long)tmp->next);
	for (tmpa = tmp->arg; tmpa != NULL; tmpa = tmpa->next) {
	    printf("@<%lu> -> <%lu>\n", (unsigned long)tmpa,
		(unsigned long)tmpa->arg);
	}
    }

    printf("*** end of function table ***\n\n");
}
