/*
 * routines to access the equation table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"

static ENODE *eptr = NULL;
static int eindex = 1;
static ELNODE *cond_list = NULL;

void init_equ_table()
{
    eptr = NULL;
}

void ins_equ_cond(lptr, rptr)
    struct tnode *lptr, *rptr;
{
    ELNODE *tmp_ptr;

    tmp_ptr = PSF_MALLOC(ELNODE);

    tmp_ptr->lhs = lptr;
    tmp_ptr->rhs = rptr;

    tmp_ptr->next = cond_list;
    cond_list = tmp_ptr;
}

void ins_equ(id, lptr, rptr)
    ID id;
    struct tnode *lptr, *rptr;
{
    ENODE *tmp_ptr;

    tmp_ptr = PSF_MALLOC(ENODE);

    tmp_ptr->index = eindex++;
    tmp_ptr->id = psf_strdup(id);
    tmp_ptr->lhs = lptr;
    tmp_ptr->rhs = rptr;
    tmp_ptr->cond = cond_list;
    cond_list = NULL;

    tmp_ptr->next = eptr;
    eptr = tmp_ptr;
}

BOOL equ_present()
{
    return eptr != NULL;
}

static void print_cond(ptr, cnt)
    ELNODE *ptr;
    int cnt;
{
    if (ptr == NULL) {
	printf("%d ", cnt);
	return;
    } else {
	print_cond(ptr->next, cnt + 1);
	if (ptr->next != NULL)
	    printf(", ");
	print_node(ptr->lhs);
	printf(" = ");
	print_node(ptr->rhs);
    }
}

static void print_equ(ptr)
    ENODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", eindex - 1);
	return;
    } else {
	print_equ(ptr->next);
	printf("[%c.%d] ", EQU, ptr->index);
	print_node(ptr->lhs);
	printf(" = ");
	print_node(ptr->rhs);
	if (ptr->cond != NULL) {
	    printf(" <= ");
	    print_cond(ptr->cond, 0);
	}
	printf(" \t{ %s }\n", ptr->id);
    }
}

void show_equ()
{
    print_equ(eptr);
}

void clear_cond(ptr)
    ELNODE *ptr;
{
    ELNODE *tmp_ptr, *next;

    for (tmp_ptr = ptr; tmp_ptr != NULL; tmp_ptr = next) {
	next = tmp_ptr->next;
	clear_tree(tmp_ptr->rhs);
	clear_tree(tmp_ptr->lhs);
    }
}

void clear_equ()
{
    ENODE *tmp_ptr, *next;

    for (tmp_ptr = eptr; tmp_ptr != NULL; tmp_ptr = next) {
	next = tmp_ptr->next;
	clear_tree(tmp_ptr->rhs);
	clear_tree(tmp_ptr->lhs);
	clear_cond(tmp_ptr->cond);
	PSF_FREE(tmp_ptr->id);
	PSF_FREE(tmp_ptr);
    }

    eptr = NULL;
    eindex = 1;
}
