/*
 * routines to access the communication table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"

static PHNODE *phptr = NULL;
static CNODE *cptr = NULL;
static int cindex = 1;

void init_com_table()
{
    cptr = NULL;
}

void ins_com(lhs, rhs, result)
    struct tnode *lhs, *rhs, *result;
{
    CNODE *tmp;

    tmp = PSF_MALLOC(CNODE);
    tmp->index = cindex++;
    tmp->lhs = lhs;
    tmp->rhs = rhs;
    tmp->result = result;
    tmp->next = cptr;
    cptr = tmp;
}

BOOL com_present()
{
    return (cptr != NULL);
}

static void print_com(ptr)
    CNODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", cindex - 1);
	return;
    }
    print_com(ptr->next);
    printf("[%c.%d] ", COM, ptr->index);
    print_node(ptr->lhs);
    printf(" ");
    print_node(ptr->rhs);
    printf(" ");
    print_node(ptr->result);
    printf("\t{ }\n");
}

void ins_ph(id)
    ID id;
{
    PHNODE *tmp;

    tmp = PSF_MALLOC(PHNODE);
    tmp->arg = lookup_var(id, LOCAL);

    tmp->next = phptr;
    phptr = tmp;
}

/*
 * Mista Curt : insert 'ph_out_of_scope()'
 */

VNODE *lookup_ph(id)
    ID id;
{
    PHNODE *tmp;
    VNODE *ptr;

    if ((ptr = lookup_var(id, LOCAL)) == NULL)
	return (NULL);

    for (tmp = phptr; tmp != NULL; tmp = tmp->next) {
	if (tmp->arg == ptr) {
	    return (ptr);
	}
    }
    return (NULL);
}

void clear_ph()
{
    PHNODE *tmp, *next;

    for (tmp = phptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	PSF_FREE(tmp);
    }
    phptr = NULL;
}

void show_com()
{
    print_com(cptr);
}

void clear_com()
{
    CNODE *tmp, *next;

    for (tmp = cptr; tmp != NULL; tmp = next) {
	next = tmp->next;
	clear_tree(tmp->lhs);
	clear_tree(tmp->rhs);
	clear_tree(tmp->result);
	PSF_FREE(tmp);
    }
    cptr = NULL;
    cindex = 1;
}
