/*
 * routines to access the atom table used by the PSF parser
 */

#include <stdio.h>
#include <string.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "global.h"
#include "tabtypes.h"

#include "yimports.h"

ANODE *aptr = NULL;
static int aindex = 1;

#define	ARITY_UNKNOWN	(-1)

void init_atm_table()
{
    aptr = NULL;
}

void add_atm_sort_ptr(sor_ptr)
    SNODE *sor_ptr;
{
    AANODE *tmp;

    tmp = PSF_MALLOC(AANODE);
    aptr->arity++;
    tmp->arg = sor_ptr;
    tmp->next = aptr->arg;
    aptr->arg = tmp;
}

static void insert_atom(id, arity)
    char *id;
    int arity;
{
    ANODE *tmp;

    tmp = PSF_MALLOC(ANODE);
    tmp->id = psf_strdup(id);
    tmp->index = aindex++;
    tmp->tag = get_tag_flag();
    tmp->arity = arity;
    tmp->arg = NULL;
    tmp->next = aptr;
    aptr = tmp;

    if (get_tag_flag() == PARAMETER)
	ins_par_item(ATM, tmp->index);
}

void ins_atm(id)
    char *id;
{
    insert_atom(id, 0);
}

void ins_atm_not_last(id)
    ID id;
{
    insert_atom(id, ARITY_UNKNOWN);
    /* arg and arity will be filled in later by ins_atm_last() */
}

static int len_aarg(arg)
    AANODE *arg;
{
    AANODE *tmp;
    int len = 0;

    for (tmp = arg; tmp != NULL; tmp = tmp->next)
	len++;
    return (len);
}

void ins_atm_last(id, arg)
    ID id;
    AANODE *arg;
{
    ANODE *tmp;

    insert_atom(id, len_aarg(arg));
    aptr->arg = arg;

    for (tmp = aptr->next; tmp != NULL; tmp = tmp->next)
	if (tmp->arity == ARITY_UNKNOWN) {
	    tmp->arg = aptr->arg;
	    tmp->arity = aptr->arity;
	} else
	    break;
}

static AANODE *append_aarg(arg1, arg2)
    AANODE *arg1, *arg2;
{
    AANODE *tmp;

    if ((tmp = arg1) != NULL) {
	tmp->next = arg2;
	return (arg1);
    } else
	return (arg2);
}

AANODE *add_atm_sort(arg, id)
    AANODE *arg;
    ID id;
{
    AANODE *tmp;

    tmp = PSF_MALLOC(AANODE);
    if ((tmp->arg = lookup_sort(id)) == NULL)	/* sort not yet in table */
	tmp->arg = ins_sort_tag(id, UNKNOWN);

    return (append_aarg(tmp, arg));
}

ANODE *lookup_atm(id)
    char *id;
{
    ANODE *tmp;

    for (tmp = aptr; tmp != NULL; tmp = tmp->next)
	if (strcmp(tmp->id, id) == 0)
	    return (tmp);

    return (NULL);
}

BOOL atm_present()
{
    return aptr != NULL;
}

static void print_aarg(ptr)
    AANODE *ptr;
{
    if (ptr == NULL)
	return;
    else {
	print_aarg(ptr->next);
	if (ptr->arg != NULL)
	    printf("[%c.%d] ", SOR, ptr->arg->index);
	else
	    printf("[%c.?] ", SOR);
    }
}

static void print_atm(ptr)
    ANODE *ptr;
{
    if (ptr == NULL) {
	printf("# %d\n", aindex - 1);
	return;
    } else {
	print_atm(ptr->next);
	printf("[%c.%d] %c %d ", ATM, ptr->index, ptr->tag, ptr->arity);
	print_aarg(ptr->arg);
	printf(" \t{ %s }\n", ptr->id);
    }
}

void show_atm()
{
    print_atm(aptr);
}

static void clear_aarg_list(ptr)
    AANODE *ptr;
{
    AANODE *tmp, *next;

    for (tmp = ptr; tmp != NULL; tmp = next) {
	next = tmp->next;
    }
}

void clear_atm()
{
    ANODE *tmp, *next;

    for (tmp = aptr; tmp != NULL; tmp = next) {
	clear_aarg_list(tmp->arg);
	next = tmp->next;
    }

    aptr = NULL;
    aindex = 1;
}
