#include <assert.h>
#include <signal.h>
#include <sys/wait.h>

#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_standards.h"
#include "psf.h"

void do_wait(kid_name)
    char *kid_name;
{
    int status;

    sysCall(wait(&status), "wait for", kid_name);

    if (WIFEXITED(status)) {
	if (WEXITSTATUS(status) == EXIT_SUCCESS)
	    return;
    } else if (WIFSIGNALED(status)) {
	(void) fprintf(stderr, "%s: %s: ", progname, kid_name);
	switch (WTERMSIG(status)) {

#define	Case(sig,txt) case sig: (void)fprintf(stderr, txt); break

	    Case(SIGHUP,	"hangup");
	    Case(SIGINT,	"keyboard interrupt");
	    Case(SIGQUIT,	"quit signal");
	    Case(SIGILL,	"illegal instruction");
	    Case(SIGTRAP,	"trace trap");
	    Case(SIGABRT,	"abort");
#ifdef SIGEMT /* for Linux */
	    Case(SIGEMT,	"emulator trap");
#endif
	    Case(SIGFPE,	"arithmetic exception");
	    Case(SIGKILL,	"killed");
	    Case(SIGBUS,	"bus error");
	    Case(SIGSEGV,	"memory fault");
#ifdef SIGSYS /* for Linux */
	    Case(SIGSYS,	"bad system call");
#endif
	    Case(SIGPIPE,	"broken pipe");
	    Case(SIGALRM,	"alarm clock");
	    Case(SIGTERM,	"terminated");
	    Case(SIGURG,	"urgent i/o condition");
	    Case(SIGSTOP,	"stopped (signal)");
	    Case(SIGTSTP,	"stopped");
	    Case(SIGCONT,	"continued");
	    Case(SIGCHLD,	"child exited");
	    Case(SIGTTIN,	"stopped (tty input)");
	    Case(SIGTTOU,	"stopped (tty output)");
	    Case(SIGIO,		"i/o possible");
	    Case(SIGXCPU,	"cpu time limit exceeded");
	    Case(SIGXFSZ,	"file size limit exceeded");
	    Case(SIGVTALRM,	"virtual timer alarm");
	    Case(SIGPROF,	"profiling timer alarm");
	    Case(SIGWINCH,	"window size changed");

#ifdef SIGLOST
	    Case(SIGLOST,	"resource lost");
#endif

	    Case(SIGUSR1,	"user defined signal 1");
	    Case(SIGUSR2,	"user defined signal 2");

#undef	Case

	default:
	    assert(THIS_CANNOT_HAPPEN);
	}

/* seems to work different now, but NOT needed anyway
#ifndef WCOREFLG
#define WCOREFLG ((union wait *) & status)->w_coredump
#endif

	if (WCOREFLG)
	    (void) fprintf(stderr, " (core dumped)\n");
	else
*/
	    (void) fprintf(stderr, "\n");
    } else
	assert(THIS_CANNOT_HAPPEN);

    cleanup();
}
