#include <stdio.h>

#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf.h"

static module old_module_list;

static bool minimal(p)
    module p;
{
    import i;

    for (i = p->imports; i; i = i->next)
	if (i->uses->status == alive)
	    return FALSE;
    return TRUE;
}

static module undeadkid(p)
    module p;
{
    import i;

    for (i = p->imports; i; i = i->next)
	if (i->uses->status != dead)
	    return i->uses;

    (void) fprintf(stderr, "\n");
    (void) fprintf(stderr,
	     "%s: I'm confused.  I was trying to tell you how module %s is\n",
		   progname, p->name);
    (void) fprintf(stderr,
       "%s: in a cycle of imports, and suddenly the cycle has disappeared.\n",
		   progname);
    exit(EXIT_HELP);
    return 0;			/* to shut up lint */
}

static void cyclic_import()
{
    module p;

    for (p = old_module_list; p->status == alive; p = undeadkid(p))
	p->status = zombie;
    (void) fprintf(stderr, "%s: cyclic imports: ", progname);
    for (; p->status == zombie; p = undeadkid(p)) {
	(void) fprintf(stderr, "%s imports ", p->name);
	p->status = alive;
    }
    (void) fprintf(stderr, "%s\n", p->name);
    exit(EXIT_SYNTAX_ERR);
}

void tsort()
{
    module p, *pp;

    if (option['v'])
	(void) fprintf(stderr, "sorting modules\n");

    old_module_list = module_list;
    module_list = 0;
    last_module = &module_list;
    while (old_module_list) {
	for (pp = &old_module_list, p = *pp; p; pp = &p->next, p = *pp)
	    if (minimal(p))
		break;
	if (!p)
	    cyclic_import();
	*pp = p->next;
	p->next = 0;
	p->status = dead;
	*last_module = p;
	last_module = &p->next;
    }
}
