#include <signal.h>
#include <stdio.h>
#include <string.h>

#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_malloc.h"
#include "defaults.h"
#include "psf.h"

#define KID ITIL_TIL

static void kid(in, out)
    char *in, *out;
{
    char *s;
    sigset_t old_mask;

    current_target = 0;
    sysCall(sigprocmask(SIG_UNBLOCK, &signal_mask, &old_mask),
		"unblock", "signals");
    stdioCall(freopen(out, "w", stdout), "create", out);
    s = PSF_NMALLOC(char, strlen(psfc_bindir) + sizeof KID);
    (void) strcpy(s, psfc_bindir);
    (void) strcat(s, KID);
    (void) execl(s, KID, in, (char *) 0);
    Complain("exec", KID);
}

void til()
{
    module m;
    char *in, *out, *s;
    sigset_t old_mask;

    m = (module) last_module;
    in = m->tnam;
    s = PSF_NMALLOC(char, strlen(m->name) + strlen(til_suffix) + 1);
    (void) strcpy(s, m->name);
    (void) strcat(s, til_suffix);
    m->tnam = s;

    if (!option['s'])
	if (outputfile)
	    mkAbsPath(out, outputfile);
	else
	    absPath(out, s);
    else
	out = s;
    tilfile = out;

    if (must_recompile(in, out)) {
	if (option['v'])
	    (void) fprintf(stderr, "compiling %s\n", in);
	sysCall(sigprocmask(SIG_BLOCK, &signal_mask, &old_mask),
		    "block", "signals");
	current_target = out;
	switch (fork()) {
	case -1:
	    Complain("fork", "");
	case 0:
	    kid(in, out);	/* doesn't return */
	default:
	    sysCall(sigprocmask(SIG_UNBLOCK, &signal_mask, &old_mask),
			"unblock", "signals");
	    do_wait(KID);
	}
	current_target = 0;
    }
}
