#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "defaults.h"
#include "psf.h"

#define KID SIMPP

static void kid(in, out)
    char *in, *out;
{
    char *s;
    sigset_t old_mask;

    current_target = 0;
    sysCall(sigprocmask(SIG_UNBLOCK, &signal_mask, &old_mask),
		"unblock", "signals");
    stdioCall(freopen(out, "w", stdout), "create", out);
    s = PSF_NMALLOC(char,strlen(psfc_bindir) + sizeof KID);
    (void) strcpy(s, psfc_bindir);
    (void) strcat(s, KID);
    (void) execl(s, KID, option['v'] ? "-nrs" : "-ns", in, (char *) 0);
    Complain("exec", KID);
}

void simpp()
{
    char *in, *out;
    sigset_t old_mask;

    in = ((module) last_module)->tnam;
    if (outputfile)
	mkAbsPath(out, outputfile);
    else
	absPath(out, in);
    tilfile = out;

    if (must_recompile(in, out)) {
	if (option['v'])
	    (void) fprintf(stderr, "applying %s to %s\n", KID, in);
	sysCall(sigprocmask(SIG_BLOCK, &signal_mask, &old_mask),
		    "block", "signals");
	current_target = out;
	switch (fork()) {
	case -1:
	    Complain("fork", "");
	case 0:
	    kid(in, out);	/* doesn't return */
	default:
	    sysCall(sigprocmask(SIG_UNBLOCK, &signal_mask, &old_mask),
			"unblock", "signals");
	    do_wait(KID);
	}
	current_target = 0;
    }
}
