%{
#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf.h"

#define Echo if(splitting)(void)fputs(yytext,split_stream)

#define syntaxError(str)						\
	{ (void)fprintf(stderr,						\
		"%s: %s line %d: \"%s\" unexpected; \"%s\" expected\n",	\
		progname, inputfile, yylineno-startlineno+1,		\
		yytext, str);						\
	  exit(EXIT_SYNTAX_ERR);					\
	}

%}

idchar		[a-zA-Z0-9']
ident		{idchar}(("-"|{idchar})*{idchar})?
newline		[\n\r\f]
whitespace	[ \t]
commentchar	[^\n\r\f\-]
comment		--(-?{commentchar})*(--|-?{newline})

%START pre dp Xmodule id body beguine Ximports bound to end post 

%%

{whitespace}{comment}   |
{newline}{comment}      |
^{comment}              Echo;

{newline}		|
{whitespace}		Echo;

<pre>"data"		|
<pre>"process"		{ Echo; unfinished_module=TRUE; BEGIN dp; }
<pre>{ident}		|
<pre>.			syntaxError("data\" or \"process");

<dp>"module"		{ Echo; BEGIN Xmodule; }
<dp>{ident}		|
<dp>.			syntaxError("module");

<Xmodule>{ident}		{ Echo;
			  if(splitting)
				change_module(yytext);
			  else
				next_module(yytext);
			  BEGIN id;
			}
<Xmodule>.		syntaxError("identifier");

<id>"begin"		{ Echo; BEGIN body; }
<id>{ident}		|
<id>.			syntaxError("begin");

<body>"begin"		{ Echo; BEGIN beguine; }
<body>"imports"		{ Echo; BEGIN Ximports; }
<body>"end"		{ Echo; BEGIN end; }
<body>{ident}		|
<body>{newline}		|
<body>.			Echo;

<beguine>"end"		{ Echo; BEGIN body; }
<beguine>{ident}	|
<beguine>{newline}	|
<beguine>.		Echo;

<Ximports>"sorts"		|
<Ximports>"functions"		|
<Ximports>"variables"		|
<Ximports>"equations"		|
<Ximports>"atoms"		|
<Ximports>"processes"		|
<Ximports>"sets"			|
<Ximports>"communications"	|
<Ximports>"definitions"	{ Echo; BEGIN body; }
<Ximports>"end"		{ Echo; BEGIN end; }
<Ximports>{ident}	{ Echo; if(!splitting)next_imports(yytext); }
<Ximports>"{"		{ Echo; BEGIN bound; }
<Ximports>{newline}	|
<Ximports>.		Echo;

<bound>"to"		{ Echo; BEGIN to; }
<bound>"}"		{ Echo; BEGIN Ximports; }
<bound>{ident}		|
<bound>{newline}	|
<bound>.		Echo;

<to>{ident}		{ Echo;
			  if(!splitting)next_imports(yytext);
			  BEGIN bound;
			}
<to>{newline}		|
<to>.			Echo;

<end>{ident}		{ Echo;
			  if(!splitting)check_id(yytext);
			  unfinished_module=FALSE;
			  BEGIN post;
			}

<post>"data"		|
<post>"process"		{ if(splitting)change_file();
			  unfinished_module=TRUE;
			  Echo;
			  BEGIN dp;
			}
<post>{ident}		|
<post>.			syntaxError("data\" or \"process");

.			{ yyless(0); BEGIN pre; }
%%
#ifdef FLEX_SCANNER
int yywrap()
{
    return 1;
}
#endif /* FLEX_SCANNER */

void lex_inputfile_change()
{
#ifdef FLEX_SCANNER
    yyrestart(yyin);
#endif /* FLEX_SCANNER */
}
