/*
**                                                                    
** H.T.G. Weffers                                                     
**                                                                    
*/


/*
** 
*/
typedef struct moduleinfo Moduleinfo;
typedef Moduleinfo *infolist;

struct moduleinfo {
	infolist next;
	char *fromlabel;
	char *tolabel;
	int noe;
};

static infolist graphinfo = NULL;
static infolist GZ = NULL;

/* 
** De-allocate allocated memory 
*/
static void DeAlloc (dt)
infolist dt;
{
	infolist pt;

	while (dt != NULL) {
		pt = dt->next;
		free (dt);
		dt = pt;
	}
}

/*
** 
*/
static bool EdgeExists(fl,tl,dt)
char *fl;
char *tl;
infolist dt;
{
	infolist ptr=dt;
	bool b = FALSE;

	while (ptr != NULL) {
		if (strEqual(fl,ptr->fromlabel) && strEqual(tl,ptr->tolabel))
		{
			b = TRUE;
		}
		ptr = ptr->next;
	}
	return b;
}

/*
**
*/
static bool NodeExists(nl,dt)
char *nl;
infolist dt;
{
	infolist ptr=dt;
	bool b = FALSE;

	while (ptr != NULL) {
		if (strEqual(ptr->fromlabel,nl) || strEqual(ptr->tolabel,nl))
			b = TRUE;
		ptr = ptr->next;
	}
	return b;
}

/*
**
*/
static void UpdateEdgeInfo(fl,tl,dt)
char *fl;
char *tl;
infolist dt;
{
	infolist ptr=dt;

	while (ptr != NULL) {
		if (strEqual(ptr->fromlabel,fl) && strEqual(ptr->tolabel,tl))
		{
			ptr->noe = ptr->noe + 1;
		}
		ptr = ptr->next;
	}
}


/*
**
*/
static module reverse(m)
module m;
{
	module v = NULL;
	module l;
	
	for (m=module_list; m ; m=l)
	{
		l = m->next;
		m->next = v;
		v = m;
	}

	return v;
}

/*
**
*/
static module lookup(m,label)
module m;
char *label;
{
	module k;
	module b = NULL;

	for (k=m; k ; k=k->next)
	{
		if (strEqual(k->name,label))
		{
			b = k;
		}
	}

	return b;
}

/*
**
*/
static void recp(s,sname,k)
module s;
char *sname;
int k;
{
	import i;
	module t;

	infolist new;

	t = lookup(s,sname);

	for (i=t->imports; i ; i=i->next)
	{	
		if (!EdgeExists(sname,i->uses->name,graphinfo))
		{
			/* Add edge to list */		
			if ((new = (infolist) malloc (sizeof(Moduleinfo))) ==NULL) { 
				fprintf(stderr,"Out of memory!\n"); 
			}
 
			new->fromlabel = sname;
			new->tolabel = i->uses->name;
			new->next = graphinfo;
			new->noe = 1;
			graphinfo = new;
		}
		else
		{
			UpdateEdgeInfo(sname,i->uses->name,graphinfo);
		}

		recp(s,i->uses->name,k++);
	}
}

/*
**
*/
static void daVGraph(s,sname,k,debug)
module s;
char *sname;
int k;
FILE *debug;
{
	import i;
	module t;
	int paren=0;
	infolist new;

	t = lookup(s,sname);

	fprintf(stdout,"l(\"Node %s\", n(\"\",[a(\"OBJECT\",\"%s\"),a(\"_GO\",\"ellipse\"),a(\"FONTFAMILY\",\"helvetica\"),a(\"FONTSTYLE\",\"bold\")],",t->name,t->name);


	if (t->imports) {

	if (t->imports)
	{
	for (i=t->imports; i ; i=i->next)
	{
		if (paren==0)
		{
			fprintf(stdout,"[");
			paren = 1;
		}
		else
		{
			fprintf(stdout,",");
		}

		if (!NodeExists(i->uses->name,GZ))
		{
			/* Add edge to list */		
			if ((new = (infolist) malloc (sizeof(Moduleinfo))) ==NULL) { 
				fprintf(stderr,"Out of memory!\n"); 
			}
 
			new->fromlabel = sname;
			new->tolabel = i->uses->name;
			new->next = GZ;
			new->noe = 1;
			GZ = new;

			fprintf(stdout,"l(\"Edge %s->%s\",e(\"\",[a(\"_DIR\",\"inverse\")],",sname,i->uses->name);

			daVGraph(s,i->uses->name,k++,debug);

			fprintf(stdout,"))");
		}
		else
		{
			UpdateEdgeInfo(sname,i->uses->name,GZ);
			fprintf(stdout,"l(\"Edge %s -> %s (%d)\",e(\"\",[a(\"_DIR\",\"inverse\")],r(\"Node %s\")))",sname,i->uses->name,k,i->uses->name);
		}


	}
	}
	}
	else
	{
		fprintf(stdout,"[]");
	}


	if (paren!=0) fprintf(stdout,"]");

	fprintf(stdout,"))");
}

/*
** 
*/
static void daVtrailer()
{
	fprintf(stdout,"\n");
	fprintf(stdout,"-- %s %s\n","daVinci representation created by","`psf -G daV'");
}

/*
** 
*/
void psfdaVincigraph()
{
	module s;
	FILE *db;

	s = reverse(module_list);
	recp(s,s->name,0);
	

	fprintf(stdout,"[");
	daVGraph(s,s->name,0,db); 
	fprintf(stdout,"]");

	daVtrailer();

	DeAlloc(GZ);

}


/*
**
** Last revision: August 16, 1995
** End-Of-File
*/

