#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

#include "psf_standards.h"

typedef struct module {
    struct module *next;	/* must be first */
    char *name;
    struct file *where;
    char *tnam;
    enum {
	alive, dead, zombie
    } status;			/* for tsort() */
    struct import *imports;
    char *whence;		/* from what library */
    bool from_stdlib;		/* don't include this one in -X output */
} *module;

typedef struct import {
    struct import *next;
    struct module *uses;
} *import;

typedef struct file {
    struct file *next;		/* must be first */
    char *name;
    int num_modules;
    struct module *last;
    bool separandum;
} *file;

/* args.c */
extern bool *option;
extern void usage PROTO_ARGS((void));
extern void parse_opts PROTO_ARGS((int argc, char **argv));
extern void parse_env PROTO_ARGS((void));
extern void parse_args PROTO_ARGS((int argc, char **argv));
/* aux.c */
extern bool must_recompile PROTO_ARGS((char *f1, char *f2));
extern void cut PROTO_ARGS((char *name));
extern void extract_modules PROTO_ARGS((bool stdlib));
extern void rm_tmpdir PROTO_ARGS((void));
/* check.c */
extern void trs_check PROTO_ARGS((void));
/* imports.c */
extern module module_list;
extern module *last_module;
extern file file_list;
extern char *inputfile;
extern int startlineno;
extern bool unfinished_module;
extern void next_module PROTO_ARGS((char *name));
extern void check_id PROTO_ARGS((char *name));
extern void next_imports PROTO_ARGS((char *name));
extern void set_target PROTO_ARGS((char *name));
extern void list_modules PROTO_ARGS((void));
extern void dump_all PROTO_ARGS((void));
extern void psfdotgraph PROTO_ARGS((void));
extern void psfgraphplacegraph PROTO_ARGS((void));
extern void psfdaVincigraph PROTO_ARGS((void));
extern void call_yylex PROTO_ARGS((char *name));
/* itil.c */
extern void itil PROTO_ARGS((void));
/* libs.c */
extern char **libraries;
extern void set_libraries PROTO_ARGS((char *list));
extern void search_libraries PROTO_ARGS((void));
/* main.c */
extern char *progname;
extern char cwd[];
extern unsigned l_cwd;
extern char *psfc_bindir;
extern char *psf_suffix;
extern unsigned l_psf_suffix;
extern char *til_suffix;
extern char *psf_tmpdir;
extern unsigned l_psf_tmpdir;
extern dev_t psf_tmp_dev;
extern ino_t psf_tmp_ino;
extern char *current_target;
extern char *target_module;
extern char *outputfile;
extern char *tilfile;
extern char *graphformat;
extern int exit_status;
extern bool splitting;
extern sigset_t signal_mask;
extern int catching[];
extern void version PROTO_ARGS((void));
extern void cleanup PROTO_ARGS((void));
extern int main PROTO_ARGS((int argc, char **argv));
/* mtil.c */
extern void mtil PROTO_ARGS((void));
/* scan.c (scan.l) */
extern void lex_inputfile_change PROTO_ARGS((void));
/* set.c */
extern void simpp PROTO_ARGS((void));
/* split.c */
extern FILE *split_stream;
extern void change_module PROTO_ARGS((char *name));
extern void change_file PROTO_ARGS((void));
extern void split PROTO_ARGS((void));
/* til.c */
extern void til PROTO_ARGS((void));
/* tsort.c */
extern void tsort PROTO_ARGS((void));
/* wait.c */
extern void do_wait PROTO_ARGS((char *kid_name));

extern FILE *yyin;
extern int yylex PROTO_ARGS((void));

#define Complain(oper,arg) do {						\
	if(*arg) {							\
	    (void)fprintf(stderr, "%s: can't %s ", progname, oper);	\
	    perror(arg);						\
	} else {							\
	    (void)fprintf(stderr, "%s: can't ", progname);		\
	    perror(oper);						\
	}								\
	cleanup();							\
    } while (0)

#define Complain2(oper,arg) do {					\
	(void)fprintf(stderr, "%s: can't %s ", progname, oper);		\
	perror(arg);							\
	exit_status=EXIT_IO_ERR;					\
	cleanup();							\
    } while (0)

#define stdioCall(call,oper,arg) do {					\
	if(!(call))							\
	    Complain(oper,arg);						\
    } while (0)

#define sysCall(call,oper,arg) do {					\
	if((call)==-1)							\
	    Complain(oper,arg);						\
    } while (0)

#define strEqual(s,t)	(strcmp(s,t) == 0)	

#define stdioCall2(call,oper,arg) do {					\
	if(!(call))							\
	    Complain2(oper,arg);					\
    } while (0)


#define Validate(p) do							\
    if(!(p)) {								\
	(void)fprintf(stderr, "%s: out of memory\n", progname);		\
	exit_status=EXIT_MEM_ERR;					\
	cleanup();							\
    } while (0)

#define absPath(abspath,relpath) do {					\
	abspath=PSF_NMALLOC(char,l_cwd+strlen(relpath));		\
	abspath=strcpy(abspath,cwd);					\
	abspath=strcat(abspath,relpath);				\
    } while (0)

#define mkAbsPath(abspath,path)						\
	if(*path=='/')							\
	    abspath=path;						\
	else								\
	    absPath(abspath,path)
