#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_redefs.h"
#include "psf_standards.h"
#include "defaults.h"
#include "psf.h"

#define KID PSF_MTIL

static bool not_in_library(m, out)
    module m;
    char *out;
{
    char *inlib;
    struct stat buf;

    if (option['i'] || !m->whence)
	return TRUE;

    inlib = PSF_NMALLOC(char, strlen(m->whence) + strlen(out) + 1);
    (void) strcpy(inlib, m->whence);
    (void) strcat(inlib, out);

    if (stat(inlib, &buf) == -1) {
	if (errno != ENOENT)
	    Complain("stat", inlib);
	m->whence = 0;
	free(inlib);
	return TRUE;
    } else {
	sysCall(symlink(inlib, out), "symlink", out);
	free(inlib);
	return FALSE;
    }
}

static bool compilandum(m, in, out)
    module m;
    char *in, *out;
{
    struct stat ibuf, obuf;

    sysCall(stat(in, &ibuf), "stat", in);

    if (option['c'])
	if (unlink(out) == -1 && errno != ENOENT)
	    Complain("remove", out);
	else
	    return not_in_library(m, out);
    else if (lstat(out, &obuf) == -1)
	if (errno != ENOENT)
	    Complain("stat", out);
	else
	    return not_in_library(m, out);
    else if (S_ISLNK(obuf.st_mode))
	if (option['i']) {
	    sysCall(unlink(out), "remove", out);
	    return TRUE;
	} else {
	    if (stat(out, &obuf)) {
		if (errno != ENOENT)
		    Complain("stat", out);
		sysCall(unlink(out), "remove", out);
		return not_in_library(m, out);
	    } else {
		return FALSE;
	    }
	}
    else if (ibuf.st_mtime < obuf.st_mtime)
	return FALSE;
    sysCall(unlink(out), "remove", out);
    return not_in_library(m, out);
}

static void kid(in, out)
    char *in, *out;
{
    char *s;
    sigset_t old_mask;

    current_target = 0;
    sysCall(sigprocmask(SIG_UNBLOCK, &signal_mask, &old_mask),
		"unblock", "signals");
    stdioCall(freopen(out, "w", stdout), "create", out);
    s = PSF_NMALLOC(char, strlen(psfc_bindir) + sizeof KID);
    (void) strcpy(s, psfc_bindir);
    (void) strcat(s, KID);
    (void) execl(s, KID, in, (char *) 0);
    Complain("exec", KID);
}

void mtil()
{
    module m;
    char *in, *out, *liberandum;
    sigset_t old_mask;

    for (m = module_list; m; m = m->next) {
	liberandum = m->tnam;
	in = psf_basename(m->tnam);
	out = PSF_NMALLOC(char, strlen(m->name) + sizeof MTILSUFFIX);
	(void) strcpy(out, m->name);
	(void) strcat(out, MTILSUFFIX);
	m->tnam = out;
	if (compilandum(m, in, out)) {
	    if (option['v'])
		(void) fprintf(stderr, "compiling %s\n", in);
	    sysCall(sigprocmask(SIG_BLOCK, &signal_mask, &old_mask),
			"block", "signals");
	    current_target = out;
	    switch (fork()) {
	    case -1:
		Complain("fork", "");
	    case 0:
		kid(in, out);	/* doesn't return */
	    default:
		sysCall(sigprocmask(SIG_UNBLOCK, &signal_mask, &old_mask),
			    "unblock", "signals");
		do_wait(KID);
	    }
	    current_target = 0;
	}
	free(liberandum);
    }
}
