#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>

#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_standards.h"
#include "version.h"
#include "psf.h"

char *progname;
char cwd[MAXPATHLEN + 1];
unsigned l_cwd;

char *psfc_bindir;
char *psf_suffix;
unsigned l_psf_suffix;
char *til_suffix;
char *psf_tmpdir;
unsigned l_psf_tmpdir;
dev_t psf_tmp_dev;
ino_t psf_tmp_ino;
char *current_target = 0;
char *target_module = 0;
char *outputfile = 0;
char *tilfile;
char *graphformat = 0;

int exit_status = EXIT_HELP;
bool splitting = FALSE;
sigset_t signal_mask;

int catching[] = {SIGHUP, SIGINT, SIGABRT, SIGPIPE, SIGXCPU, SIGXFSZ, 0};

void version()
{
    (void) fprintf(stderr, "psf version %s, last compiled %s\n",
		   VERSION, __DATE__);
}

void cleanup()
{
    if (current_target) {
	if (unlink(current_target) == -1) {
	    if (errno != ENOENT) {
		(void) fprintf(stderr, "%s: can't remove ", progname);
		perror(current_target);
	    }
	} else {
	    (void) fprintf(stderr, "%s: %s removed\n", progname,
			   psf_basename(current_target));
	}
    }
    exit(exit_status);
}

static void handler(sig)
    int sig;
{
    (void) fprintf(stderr, "%s: interrupted\n", progname);
    exit_status = EXIT_CTRL_C;
    cleanup();

#ifdef lint
    (void) sig;
#endif
}

static void init(argc, argv)
    int argc;
    char **argv;
{
    int i;

#ifdef DEBUG
    extern int malloc_debug();

    (void) malloc_debug(2);
#endif

    if (argc == 0) {
	(void) fprintf(stderr, "who am I?\n");
	exit(EXIT_CMD_LINE_ERR);
    }
    progname = psf_basename(*argv);

    if (argc == 1)
	usage();

#ifdef SYSV
    stdioCall(getcwd(cwd, MAXPATHLEN),
			"name current directory (or a parent)", "");
#else /* SYSV */
    stdioCall(getcwd(cwd, MAXPATHLEN),
			"name current directory (or a parent)", "");
    /* Hmmm, nowadays it must be getcwd, but is this also true on BSD systems?
    stdioCall(getwd(cwd), "name current directory (or a parent)", "");
    */
#endif /* SYSV */

    (void) strcat(cwd, "/");
    l_cwd = strlen(cwd) + 1;

    sysCall(sigemptyset(&signal_mask), "initialize", "signal mask");
    for (i=0; catching[i]; i++)
	sysCall(sigaddset(&signal_mask, catching[i]), "add signal", "to mask");
}

int main(argc, argv)
    int argc;
    char **argv;
{
    int i;
    void (*old_handler)();

    init(argc, argv);
    parse_opts(argc, argv);
    if (option['v'])
	version();
    if (!target_module && (optind == argc))
	if (option['v'])
	    exit(EXIT_SUCCESS);
	else {
	    (void) fprintf(stderr,
		   "%s: give input file(s) or use the -m option\n", progname);
	    exit(EXIT_CMD_LINE_ERR);
	}
    parse_env();
    if (target_module)
	set_target(target_module);
    parse_args(argc, argv);
    if (!option['S']) {
	search_libraries();
	tsort();
	if (target_module)
	    cut(target_module);
    }
    if (option['l']) {
	list_modules();
	exit(EXIT_SUCCESS);
    }
    /*
     * PSF Dependency Graph
     */
    if (graphformat) {
	if (outputfile)
	    stdioCall(freopen(outputfile, "w", stdout), "create", outputfile);
	if (!strcmp(graphformat, "dot"))
	    psfdotgraph();
	else if (!strcmp(graphformat, "daV"))
	    psfdaVincigraph();
	else if (!strcmp(graphformat, "gp"))
	    psfgraphplacegraph();
	else {
	    (void) fprintf(stderr, "%s: unknown graph-format \"%s\" for option -G\n",
		progname, graphformat);
	    exit(EXIT_CMD_LINE_ERR);
	}
	exit(EXIT_SUCCESS);
    }

    if (last_module == &module_list) {
	(void) fprintf(stderr, "%s: no modules found\n", progname);
	exit(EXIT_SYNTAX_ERR);
    }
    for (i=0; catching[i]; i++) {
	sysCall((long) (old_handler = signal(catching[i], SIG_IGN)),
				"retrieve", "signal handler");
	if (old_handler != SIG_IGN)
	    sysCall((long) signal(catching[i], handler),
				"install", "signal handler");
    }
    split();
    if (option['S'])
	exit(EXIT_SUCCESS);
    if (option['x'] || option['X']) {
	extract_modules(option['x']);
	exit(EXIT_SUCCESS);
    }
    sysCall(chdir(psf_tmpdir), "chdir to", psf_tmpdir);
    mtil();
    itil();
    til();
    if (option['s'])
	simpp();
    if (option['t'])
	trs_check();
    if (option['c'])
	rm_tmpdir();
    return EXIT_SUCCESS;
}
