#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_malloc.h"
#include "psf_redefs.h"
#include "psf.h"

char **libraries;

void set_libraries(list)
    char *list;
{
    unsigned num_libs, u;
    char *s, *t, **l;
    struct stat buf;

    num_libs = 0;
    for (s = list; s; s = strchr(s, ':')) {
	s++;
	num_libs++;
    }
    libraries = PSF_NMALLOC(char *, num_libs + 1);

    l = libraries;
    s = list;
    while (num_libs--) {
	if (!(t = strchr(s, ':')))
	    t = strchr(s, '\0');
	u = t - s;
	*l = PSF_NMALLOC(char, u + 2);
	(void) strncpy(*l, s, (int) u);
	(*l++)[u] = '\0';
	s = t + 1;
    }
    *l = 0;

    for (l = libraries; *l; l++) {
	if (stat(*l, &buf) == -1) {
	    if (option['v']) {
		(void) fprintf(stderr, "%s: warning: invalid PSFPATH: ",
			       progname);
		perror(*l);
	    }
	} else if (!S_ISDIR(buf.st_mode)) {
	    if (option['v']) {
		(void) fprintf(stderr, "%s: warning: invalid PSFPATH: %s: %s\n",
			       progname, *l, strerror(ENOTDIR));
	    }
	} else if (buf.st_dev == psf_tmp_dev && buf.st_ino == psf_tmp_ino) {
	    psf_tmpdir[l_psf_tmpdir - 2] = '\0';
	    (void) fprintf(stderr, "%s: scratch directory %s in %sPSFPATH\n",
			   progname, psf_tmpdir,
			   strEqual(list, ".") ? "(default) " : "");
	    exit(EXIT_CMD_LINE_ERR);
	}
	if (**l)
	    (void) strcat(*l, "/");
    }
}

static void complain(name, parent)
	char *name;
	char *parent;
{
    (void) fprintf(stderr, "%s: can't find module %s", progname, name);
    if (parent)
	(void) fprintf(stderr, " imported into module %s\n", parent);
    else
	(void) fprintf(stderr, "\n");
    (void) fprintf(stderr, "%s: there is no file %s%s in the library, either\n",
		   		progname, name, psf_suffix);
    exit(EXIT_SYNTAX_ERR);
}

static void cant_find(kid)
    module kid;
{
    module m;
    import i;

    if (target_module && (strcmp(kid->name, target_module) == 0))
	complain(target_module, (char *) 0);		/* doesn't return */

    for (m = module_list; m; m = m->next)
	for (i = m->imports; i; i = i->next)
	    if (i->uses == kid)
		complain(kid->name, m->name);		/* doesn't return */

    (void) fprintf(stderr,
		    "%s: This can't happen, but it has happened anyway.\n",
			progname);
    (void) fprintf(stderr,
		    "%s: I was looking for module %s and I couldn't find it,\n",
			progname, kid->name);
    (void) fprintf(stderr,
	     "%s: and now I can't even remember why I thought I needed it.\n",
			progname);
    exit(EXIT_HELP);
}

void search_libraries()
{
    module m;
    char **l;
    char *in;

    if (option['v'])
	for (m = module_list; m; m = m->next)
	    if (!m->where) {
		(void) fprintf(stderr, "searching libraries\n");
		break;
	    }
    for (m = module_list; m; m = m->next)
	if (!m->where)
	    for (l = libraries; *l; l++) {
		in = PSF_NMALLOC(char,
				strlen(*l) + strlen(m->name) + l_psf_suffix);
		(void) strcpy(in, *l);
		(void) strcat(in, m->name);
		(void) strcat(in, psf_suffix);
		if (freopen(in, "r", yyin)) {
		    call_yylex(in);
		    if (!m->where) {
			(void) fprintf(stderr,
				   "%s: file %s does not contain module %s\n",
				       progname, in, m->name);
			exit(EXIT_SYNTAX_ERR);
		    }
		    m->from_stdlib = **l=='/';
		    mkAbsPath(m->whence, *l);
		    break;
		} else
		    free(in);
	    }

    for (m = module_list; m; m = m->next) {
	if (!m->where)
	    cant_find(m);
    }
}
