#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "xtiltype.h"
#include "main.h"
#include "normutil.h"

static FILE *output;

void set_output_file(fp)
    FILE *fp;
{
    output = fp;
}

static char table_char(t)
    tabletype t;
{
    switch (t) {
    case PRM:
	return ('P');
    case REN:
	return ('R');
    case BIN:
	return ('B');
    case IMP:
	return ('I');
    case MOD:
	return ('M');
    case UND:
	return ('U');
    default:
	return ('0' + t);
    }
}

void write_index(ind)
    struct indextype *ind;
{
    fprintf(output, "[%u.%c.%d] ", ind->origin,
	    table_char(ind->table), ind->key);
}

void write_indexlist(ind_l)
    struct indexlist *ind_l;
{
    int anum;

    fprintf(output, "%u  ", ind_l->a);
    if (ind_l->a > 0) {
	for (anum = 0; anum < ind_l->a; anum++)
	    write_index(&ind_l->indlist[anum]);
    }
}

void write_ae_term(ae_t)
    struct ae_term *ae_t;
{
    int anum;

    if (ae_t->t == TUPLE) {
	fprintf(output, "< %u , ", ae_t->a);
	for (anum = 0; anum < ae_t->a; anum++)
	    write_ae_term(&ae_t->ae_list[anum]);
	fprintf(output, ">");
    } else {
	write_index(&ae_t->ind);
	if (ae_t->a > 0) {
	    fprintf(output, "(");
	    for (anum = 0; anum < ae_t->a; anum++)
		write_ae_term(&ae_t->ae_list[anum]);
	    fprintf(output, ")");
	}
    }
}

void write_s_term(s_t)
    struct s_term *s_t;
{
    int anum;

    fprintf(output, "<%c,%u>(", s_t->fun, s_t->a);
    for (anum = 0; anum < s_t->a; anum++) {
	if (s_t->u_tag[anum] == 0) {
	    write_ae_term(s_t->arr[anum].ae_t);
	} else {
	    write_s_term(s_t->arr[anum].s_t);
	}
    }
    fprintf(output, ")");
}

void write_pr_expr(p_expr)
    struct process_expr *p_expr;
{
    int anum;

    if (p_expr->fun == AET) {
	write_ae_term(&p_expr->proc_expr.pe2);
    } else {
	switch (p_expr->fun) {
	case SKP:
	    fprintf(output, "<%c> ", SKP);
	    break;
	case DLK:
	    fprintf(output, "<%c> ", DLK);
	    break;
	case SUM:
	case MRG:
	case ENC:
	case HID:
	    fprintf(output, "<%c>(", p_expr->fun);
	    write_index(&p_expr->proc_expr.pe1.ind);
	    write_pr_expr(p_expr->proc_expr.pe1.pe);
	    fprintf(output, ") ");
	    break;

#ifndef NOIF
	case IF:
	    fprintf(output, "<%c>(", p_expr->fun);
	    write_ae_term(&p_expr->proc_expr.pe4.aex);
	    write_ae_term(&p_expr->proc_expr.pe4.aey);
	    write_pr_expr(p_expr->proc_expr.pe4.pe);
	    fprintf(output, ") ");
	    break;
#endif

	case ALT:
	case SEQ:
	case PAR:
	case INTR:
	case DISR:
	case STAR:
	case SHARP:
	    fprintf(output, "<%c,%u>(", p_expr->fun,
		    p_expr->proc_expr.pe3.a);
	    for (anum = 0; anum < p_expr->
		    proc_expr.pe3.a; anum++)
		write_pr_expr(&p_expr->
			      proc_expr.pe3.pe[anum]);
	    fprintf(output, ")");
	    break;
	case PRIO:
	    fprintf(output, "<%c>(", p_expr->fun);
	    write_indexlist(&p_expr->proc_expr.pe5.sets);
	    write_pr_expr(p_expr->proc_expr.pe5.pe);
	    fprintf(output, ")");
	    break;
	}
    }
}

void write_sor_tuple(sor)
    sor_tuple *sor;
{
    fprintf(output, "%c  ", sor->t);
    fprintf(output, "{ %s }\n", sor->ff);
}

void write_fun_tuple(fun)
    fun_tuple *fun;
{
    fprintf(output, "%c  ", fun->t);
    write_indexlist(&fun->sor_indlist);
    write_indexlist(&fun->return_list);
    fprintf(output, "{ %s }\n", fun->ff);
}

void write_atm_tuple(atm)
    atm_tuple *atm;
{
    fprintf(output, "%c  ", atm->t);
    write_indexlist(&atm->sor_indlist);
    fprintf(output, "{ %s }\n", atm->ff);
}

void write_pro_tuple(pro)
    pro_tuple *pro;
{
    fprintf(output, "%c  ", pro->t);
    write_indexlist(&pro->sor_indlist);
    fprintf(output, "{ %s }\n", pro->ff);
}

void write_set_tuple(set)
    set_tuple *set;
{
    fprintf(output, "%c  ", set->t);
    write_index(&set->ind);
    if (set->t != PARAMETER && set->u_tag != -1) {
	if (set->u_tag == 0)
	    write_index(&set->construct.sort);
	else
	    write_s_term(&set->construct.set_term);
    }
    fprintf(output, "  { %s }\n", set->ff);
}

void write_com_tuple(com)
    com_tuple *com;
{
    if (Option_Debug)
	fprintf(output, "%c  ", com->t);
    write_ae_term(&com->aet[0]);
    fprintf(output, "  ");
    write_ae_term(&com->aet[1]);
    fprintf(output, "  ");
    write_ae_term(&com->aet[2]);
    fprintf(output, "  { %s }\n", com->ff);
}

void write_var_tuple(var)
    var_tuple *var;
{
    fprintf(output, "%c  ", var->t);
    write_index(&var->ind);
    fprintf(output, "{ %s }\n", var->ff);
}

void write_equ_tuple(equ)
    equ_tuple *equ;
{
    int c;

    if (Option_Debug)
	fprintf(output, "%c  ", equ->t);
    write_ae_term(&equ->aet1);
    fprintf(output, " = ");
    write_ae_term(&equ->aet2);
    if (equ->a > 0) {
	fprintf(output, " <= %d  ", equ->a);
	for (c = 0; c < equ->a; c++) {
	    if (c)
		fprintf(output, " , ");
	    write_ae_term(&equ->guard[c].aet1);
	    fprintf(output, " = ");
	    write_ae_term(&equ->guard[c].aet2);
	}
    }
    fprintf(output, "  { %s }\n", equ->ff);
}

void write_def_tuple(def)
    def_tuple *def;
{
    if (Option_Debug)
	fprintf(output, "%c  ", def->t);
    write_ae_term(&def->ae_t);
    fprintf(output, " = ");
    write_pr_expr(&def->p_expr);
    fprintf(output, "  { %s }\n", def->ff);
}

void write_par_tuple(par)
    par_tuple *par;
{
    fprintf(output, "%c  ", par->t);
    write_indexlist(&par->par_attr);
    fprintf(output, "{ %s }\n", par->ff);
}

void write_mod_tuple(mod)
    mod_tuple *mod;
{
    fprintf(output, "{ %s }\n", mod->ff);
}

void write_module(mod, fp)
    struct module *mod;
    FILE *fp;
{
    tabletype i;
    int j;
    int ent;

    set_output_file(fp);
    fprintf(output, "module %s\n", mod->name);

    fprintf(output, "table M\n# %u\n", mod->entries_table[MOD]);
    for (j = 1; j <= mod->entries_table[MOD]; j++) {
	fprintf(output, "[%u.M.%d] ", mod->origin, j);
	write_mod_tuple(&mod->mod[j]);
    }
    fprintf(output, "end\n");

    for (i = 1; i < MTABLE; i++) {
	if (i > DEF && i != PRM)
	    continue;

	ent = 0;
	for (j = 1; j <= mod->entries_table[i]; j++)
	    if ((!not_to_be_printed(mod, i, j)) || Option_Debug)
		ent++;

	if (ent == 0)
	    continue;

	fprintf(output, "table %c\n# %u\n", table_char(i), ent);
	for (j = 1; j <= mod->entries_table[i]; j++) {
	    if (not_to_be_printed(mod, i, j) && ! Option_Debug)
		continue;
	    switch (i) {
	    case SOR:
		fprintf(output, "[%u.%c.%d] ",
			mod->sor[j].o, table_char(i),
			mod->sor[j].k);
		write_sor_tuple(&mod->sor[j]);
		break;
	    case FUN:
		fprintf(output, "[%u.%c.%d] ",
			mod->fun[j].o, table_char(i),
			mod->fun[j].k);
		write_fun_tuple(&mod->fun[j]);
		break;
	    case ATM:
		fprintf(output, "[%u.%c.%d] ",
			mod->atm[j].o, table_char(i),
			mod->atm[j].k);
		write_atm_tuple(&mod->atm[j]);
		break;
	    case PRO:
		fprintf(output, "[%u.%c.%d] ",
			mod->pro[j].o, table_char(i),
			mod->pro[j].k);
		write_pro_tuple(&mod->pro[j]);
		break;
	    case SET:
		fprintf(output, "[%u.%c.%d] ",
			mod->set[j].o, table_char(i),
			mod->set[j].k);
		write_set_tuple(&mod->set[j]);
		break;
	    case COM:
		fprintf(output, "[%u.%c.%d] ",
			mod->com[j].o, table_char(i),
			mod->com[j].k);
		write_com_tuple(&mod->com[j]);
		break;
	    case VAR:
		fprintf(output, "[%u.%c.%d] ",
			mod->var[j].o, table_char(i),
			mod->var[j].k);
		write_var_tuple(&mod->var[j]);
		break;
	    case EQU:
		fprintf(output, "[%u.%c.%d] ",
			mod->equ[j].o, table_char(i),
			mod->equ[j].k);
		write_equ_tuple(&mod->equ[j]);
		break;
	    case DEF:
		fprintf(output, "[%u.%c.%d] ",
			mod->def[j].o, table_char(i),
			mod->def[j].k);
		write_def_tuple(&mod->def[j]);
		break;
	    case PRM:
		fprintf(output, "[%u.%c.%d] ",
			mod->par[j].o, table_char(i),
			mod->par[j].k);
		write_par_tuple(&mod->par[j]);
		break;
	    }
	}
	fprintf(output, "end\n");
    }
    fprintf(output, "\nend\n");
}
