#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "xtiltype.h"
#include "readxtiltype.h"
#include "reorigin.h"

static mod_tuple *mods;
static Ent *mod_ent;

static void reorigin_index(index)
    struct indextype *index;
{
    index->origin = mods[index->origin].o;
    if (index->key != -1)
	index->key += mod_ent[index->origin][index->table];
}

static void reorigin_indexarr(nr, indlist)
    unsigned int nr;
    struct indextype *indlist;
{
    int i;

    for (i = 0; i < nr; i++) {
	reorigin_index(&indlist[i]);
    }
}

static void reorigin_indexlist(il)
    struct indexlist *il;
{
    reorigin_indexarr(il->a, il->indlist);
}

static void reorigin_ae_term(term)
    struct ae_term *term;
{
    int i;

    if (term->t == TUPLE) {
	for (i = 0; i < term->a; i++)
	    reorigin_ae_term(&(term->ae_list[i]));
    } else {
	reorigin_index(&term->ind);
	for (i = 0; i < term->a; i++)
	    reorigin_ae_term(&(term->ae_list[i]));
    }
}

static void reorigin_s_term(term)
    struct s_term *term;
{
    int i;

    for (i = 0; i < term->a; i++) {
	if (term->u_tag[i] == 0) {
	    reorigin_ae_term(term->arr[i].ae_t);
	} else {
	    reorigin_s_term(term->arr[i].s_t);
	}
    }
}

static void reorigin_process_expr(p_expr)
    struct process_expr *p_expr;
{
    int i;
    arity arg;

    if (p_expr->fun == AET) {
	reorigin_ae_term(&p_expr->proc_expr.pe2);
    } else {
	switch (p_expr->fun) {
	case ALT:
	case SEQ:
	case PAR:
	case INTR:
	case DISR:
	case STAR:
	case SHARP:
	    arg = p_expr->proc_expr.pe3.a;
	    for (i = 0; i < arg; i++)
		reorigin_process_expr(&p_expr->
				      proc_expr.pe3.pe[i]);
	    break;
	case SKP:
	case DLK:
	    break;
	case SUM:
	case MRG:
	case ENC:
	case HID:
	    reorigin_index(&p_expr->proc_expr.pe1.ind);
	    reorigin_process_expr(p_expr->proc_expr.pe1.pe);
	    break;

#ifndef NOIF
	case IF:
	    reorigin_ae_term(&p_expr->proc_expr.pe4.aex);
	    reorigin_ae_term(&p_expr->proc_expr.pe4.aey);
	    reorigin_process_expr(p_expr->proc_expr.pe4.pe);
	    break;
#endif
	case PRIO:
	    reorigin_indexlist(&p_expr->proc_expr.pe5.sets);
	    reorigin_process_expr(p_expr->proc_expr.pe5.pe);
	    break;
	}
    }
}

static void reorigin_sor_tuple(sor_t)
    sor_tuple *sor_t;
{
    sor_t->o = mods[sor_t->o].o;
    sor_t->k += mod_ent[sor_t->o][SOR];
}

static void reorigin_fun_tuple(fun_t)
    fun_tuple *fun_t;
{
    reorigin_indexlist(&fun_t->sor_indlist);
    reorigin_indexlist(&fun_t->return_list);
    fun_t->o = mods[fun_t->o].o;
    fun_t->k += mod_ent[fun_t->o][FUN];
}

static void reorigin_atm_tuple(atm_t)
    atm_tuple *atm_t;
{
    reorigin_indexlist(&atm_t->sor_indlist);
    atm_t->o = mods[atm_t->o].o;
    atm_t->k += mod_ent[atm_t->o][ATM];
}

static void reorigin_pro_tuple(pro_t)
    pro_tuple *pro_t;
{
    reorigin_indexlist(&pro_t->sor_indlist);
    pro_t->o = mods[pro_t->o].o;
    pro_t->k += mod_ent[pro_t->o][PRO];
}

static void reorigin_set_tuple(set_t)
    set_tuple *set_t;
{
    reorigin_index(&set_t->ind);
    if (set_t->t != IMPORTS && set_t->t != PARAMETER) {
	if (set_t->u_tag == 0) {
	    reorigin_index(&set_t->construct.sort);
	} else {
	    reorigin_s_term(&set_t->construct.set_term);
	}
    }
    set_t->o = mods[set_t->o].o;
    set_t->k += mod_ent[set_t->o][SET];
}

static void reorigin_com_tuple(com_t)
    com_tuple *com_t;
{
    reorigin_ae_term(&com_t->aet[0]);
    reorigin_ae_term(&com_t->aet[1]);
    reorigin_ae_term(&com_t->aet[2]);
    com_t->o = mods[com_t->o].o;
    com_t->k += mod_ent[com_t->o][COM];
}

static void reorigin_var_tuple(var_t)
    var_tuple *var_t;
{
    reorigin_index(&var_t->ind);
    var_t->o = mods[var_t->o].o;
    var_t->k += mod_ent[var_t->o][VAR];
}

static void reorigin_equ_tuple(equ_t)
    equ_tuple *equ_t;
{
    int i;

    reorigin_ae_term(&equ_t->aet1);
    reorigin_ae_term(&equ_t->aet2);
    for (i = 0; i < equ_t->a; i++) {
	reorigin_ae_term(&equ_t->guard[i].aet1);
	reorigin_ae_term(&equ_t->guard[i].aet2);
    }
    equ_t->o = mods[equ_t->o].o;
    equ_t->k += mod_ent[equ_t->o][EQU];
}

static void reorigin_def_tuple(def_t)
    def_tuple *def_t;
{
    reorigin_ae_term(&def_t->ae_t);
    reorigin_process_expr(&def_t->p_expr);
    def_t->o = mods[def_t->o].o;
    def_t->k += mod_ent[def_t->o][DEF];
}

static void reorigin_par_tuple(par_t)
    par_tuple *par_t;
{
    reorigin_indexlist(&par_t->par_attr);
    par_t->o = mods[par_t->o].o;
    par_t->k += mod_ent[par_t->o][PRM];
}

void reorigin(im, table, key, ent)
    struct module *im;
    tabletype table;
    keytype key;
    Ent *ent;
{
    mods = im->mod;
    mod_ent = ent;
    switch (table) {
    case SOR:
	reorigin_sor_tuple(&im->sor[key]);
	break;
    case FUN:
	reorigin_fun_tuple(&im->fun[key]);
	break;
    case ATM:
	reorigin_atm_tuple(&im->atm[key]);
	break;
    case PRO:
	reorigin_pro_tuple(&im->pro[key]);
	break;
    case SET:
	reorigin_set_tuple(&im->set[key]);
	break;
    case COM:
	reorigin_com_tuple(&im->com[key]);
	break;
    case VAR:
	reorigin_var_tuple(&im->var[key]);
	break;
    case EQU:
	reorigin_equ_tuple(&im->equ[key]);
	break;
    case DEF:
	reorigin_def_tuple(&im->def[key]);
	break;
    case PRM:
	reorigin_par_tuple(&im->par[key]);
	break;
    }
}
