#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "xtiltype.h"
#include "normutil.h"

struct pair {
    struct indextype ind;
    origintype origin;
    tabletype table;
    keytype key;
};

static struct pair *rem_pair = NULL;
static int nr_pair = 0;

void remember(im, imt, imk, mod, ts, ks)
    struct module *im;
    tabletype imt;
    keytype imk;
    struct module *mod;
    tabletype ts;
    keytype ks;
{
    if (nr_pair == 0)
	rem_pair = PSF_MALLOC(struct pair);
    else
	rem_pair = PSF_REALLOC(rem_pair, struct pair, nr_pair + 1);
    rem_pair[nr_pair].origin = origin(im, imt, imk);
    rem_pair[nr_pair].table = imt;
    rem_pair[nr_pair].key = origin_key(im, imt, imk);
    rem_pair[nr_pair].ind.origin = origin(mod, ts, ks);
    rem_pair[nr_pair].ind.table = ts;
    rem_pair[nr_pair].ind.key = origin_key(mod, ts, ks);
    nr_pair++;

#ifdef	DEBUG
    fprintf(stderr, "rem: [%u.%u.%d] - [%u.%u.%d]\n", origin(im, imt, imk), imt, origin_key(im, imt, imk), origin(mod, ts, ks), ts, origin_key(mod, ts, ks));
#endif
}

int is_a_binding(ind)
struct indextype *ind;
{
    int i;

    for (i = 0; i < nr_pair; i++) {
	if (rem_pair[i].origin == ind->origin &&
	    rem_pair[i].table == ind->table &&
	    rem_pair[i].key == ind->key)
	    return(1);
    }
    return(0);
}

struct indextype *get_actual_object(ind)
    struct indextype *ind;
{
    int i;

#ifdef	DEBUG
    fprintf(stderr, "gao: [%u.%u.%d]\n", ind->origin, ind->table, ind->key);
#endif

    for (i = 0; i < nr_pair; i++) {
	if (rem_pair[i].origin == ind->origin &&
		rem_pair[i].table == ind->table &&
		rem_pair[i].key == ind->key)
	    return (&rem_pair[i].ind);
    }

#ifdef	DEBUG
    fprintf(stderr, "no pair found\n");
#endif

    return (NULL);
}

static struct indextype *unbound = NULL;
static int nr_unbound = 0;

void set_not_bound(mod, table, key)
    struct module *mod;
    tabletype table;
    keytype key;
{
    if (nr_unbound == 0)
	unbound = PSF_MALLOC(struct indextype);
    else
	unbound = PSF_REALLOC(unbound, struct indextype, nr_unbound + 1);
    unbound[nr_unbound].origin = origin(mod, table, key);
    unbound[nr_unbound].table = table;
    unbound[nr_unbound].key = key;
    nr_unbound++;
}

int not_bound(ind)
    struct indextype *ind;
{
    int i;

    for (i = 0; i < nr_unbound; i++) {
	if (unbound[i].origin == ind->origin &&
		unbound[i].table == ind->table &&
		unbound[i].key == ind->key)
	    return (1);
    }
    return (0);
}

void init_rememberbin()
{
    if (nr_pair)
	PSF_FREE(rem_pair);
    rem_pair = NULL;
    nr_pair = 0;
    if (nr_unbound)
	free(unbound);
    unbound = NULL;
    nr_unbound = 0;
}
